package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  CodeHookInterfaceVersion,
  LambdaARN
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LambdaCodeHook(
    lambdaARN: LambdaARN,
    codeHookInterfaceVersion: CodeHookInterfaceVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.LambdaCodeHook = {
    import LambdaCodeHook.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.LambdaCodeHook
      .builder()
      .lambdaARN(LambdaARN.unwrap(lambdaARN): java.lang.String)
      .codeHookInterfaceVersion(
        CodeHookInterfaceVersion.unwrap(
          codeHookInterfaceVersion
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.LambdaCodeHook.ReadOnly =
    zio.aws.lexmodelsv2.model.LambdaCodeHook.wrap(buildAwsValue())
}
object LambdaCodeHook {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.LambdaCodeHook
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.LambdaCodeHook =
      zio.aws.lexmodelsv2.model
        .LambdaCodeHook(lambdaARN, codeHookInterfaceVersion)
    def lambdaARN: LambdaARN
    def codeHookInterfaceVersion: CodeHookInterfaceVersion
    def getLambdaARN: ZIO[Any, Nothing, LambdaARN] = ZIO.succeed(lambdaARN)
    def getCodeHookInterfaceVersion
        : ZIO[Any, Nothing, CodeHookInterfaceVersion] =
      ZIO.succeed(codeHookInterfaceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.LambdaCodeHook
  ) extends zio.aws.lexmodelsv2.model.LambdaCodeHook.ReadOnly {
    override val lambdaARN: LambdaARN =
      zio.aws.lexmodelsv2.model.primitives.LambdaARN(impl.lambdaARN())
    override val codeHookInterfaceVersion: CodeHookInterfaceVersion =
      zio.aws.lexmodelsv2.model.primitives
        .CodeHookInterfaceVersion(impl.codeHookInterfaceVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.LambdaCodeHook
  ): zio.aws.lexmodelsv2.model.LambdaCodeHook.ReadOnly = new Wrapper(impl)
}
