package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SlotDefaultValueSpecification(
    defaultValueList: Iterable[zio.aws.lexmodelsv2.model.SlotDefaultValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotDefaultValueSpecification = {
    import SlotDefaultValueSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotDefaultValueSpecification
      .builder()
      .defaultValueList(defaultValueList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification
      .wrap(buildAwsValue())
}
object SlotDefaultValueSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotDefaultValueSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification =
      zio.aws.lexmodelsv2.model
        .SlotDefaultValueSpecification(defaultValueList.map { item =>
          item.asEditable
        })
    def defaultValueList
        : List[zio.aws.lexmodelsv2.model.SlotDefaultValue.ReadOnly]
    def getDefaultValueList: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.SlotDefaultValue.ReadOnly
    ]] = ZIO.succeed(defaultValueList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotDefaultValueSpecification
  ) extends zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.ReadOnly {
    override val defaultValueList
        : List[zio.aws.lexmodelsv2.model.SlotDefaultValue.ReadOnly] = impl
      .defaultValueList()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.SlotDefaultValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotDefaultValueSpecification
  ): zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.ReadOnly =
    new Wrapper(impl)
}
