package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.FilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SlotFilter(
    name: zio.aws.lexmodelsv2.model.SlotFilterName,
    values: Iterable[FilterValue],
    operator: zio.aws.lexmodelsv2.model.SlotFilterOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotFilter = {
    import SlotFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotFilter.wrap(buildAwsValue())
}
object SlotFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotFilter =
      zio.aws.lexmodelsv2.model.SlotFilter(name, values, operator)
    def name: zio.aws.lexmodelsv2.model.SlotFilterName
    def values: List[FilterValue]
    def operator: zio.aws.lexmodelsv2.model.SlotFilterOperator
    def getName: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SlotFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SlotFilterOperator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotFilter
  ) extends zio.aws.lexmodelsv2.model.SlotFilter.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.SlotFilterName =
      zio.aws.lexmodelsv2.model.SlotFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.primitives.FilterValue(item)
      }
      .toList
    override val operator: zio.aws.lexmodelsv2.model.SlotFilterOperator =
      zio.aws.lexmodelsv2.model.SlotFilterOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotFilter
  ): zio.aws.lexmodelsv2.model.SlotFilter.ReadOnly = new Wrapper(impl)
}
