package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.BuiltInOrCustomSlotTypeId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Specifications(
    slotTypeId: BuiltInOrCustomSlotTypeId,
    valueElicitationSetting: zio.aws.lexmodelsv2.model.SubSlotValueElicitationSetting
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.Specifications = {
    import Specifications.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.Specifications
      .builder()
      .slotTypeId(
        BuiltInOrCustomSlotTypeId.unwrap(slotTypeId): java.lang.String
      )
      .valueElicitationSetting(valueElicitationSetting.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.Specifications.ReadOnly =
    zio.aws.lexmodelsv2.model.Specifications.wrap(buildAwsValue())
}
object Specifications {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.Specifications
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.Specifications =
      zio.aws.lexmodelsv2.model
        .Specifications(slotTypeId, valueElicitationSetting.asEditable)
    def slotTypeId: BuiltInOrCustomSlotTypeId
    def valueElicitationSetting
        : zio.aws.lexmodelsv2.model.SubSlotValueElicitationSetting.ReadOnly
    def getSlotTypeId: ZIO[Any, Nothing, BuiltInOrCustomSlotTypeId] =
      ZIO.succeed(slotTypeId)
    def getValueElicitationSetting: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.SubSlotValueElicitationSetting.ReadOnly
    ] = ZIO.succeed(valueElicitationSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.Specifications
  ) extends zio.aws.lexmodelsv2.model.Specifications.ReadOnly {
    override val slotTypeId: BuiltInOrCustomSlotTypeId =
      zio.aws.lexmodelsv2.model.primitives
        .BuiltInOrCustomSlotTypeId(impl.slotTypeId())
    override val valueElicitationSetting
        : zio.aws.lexmodelsv2.model.SubSlotValueElicitationSetting.ReadOnly =
      zio.aws.lexmodelsv2.model.SubSlotValueElicitationSetting
        .wrap(impl.valueElicitationSetting())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.Specifications
  ): zio.aws.lexmodelsv2.model.Specifications.ReadOnly = new Wrapper(impl)
}
