package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TextLogSetting(
    enabled: Boolean,
    destination: zio.aws.lexmodelsv2.model.TextLogDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TextLogSetting = {
    import TextLogSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TextLogSetting
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .destination(destination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TextLogSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.TextLogSetting.wrap(buildAwsValue())
}
object TextLogSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TextLogSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TextLogSetting =
      zio.aws.lexmodelsv2.model.TextLogSetting(enabled, destination.asEditable)
    def enabled: Boolean
    def destination: zio.aws.lexmodelsv2.model.TextLogDestination.ReadOnly
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.TextLogDestination.ReadOnly
    ] = ZIO.succeed(destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TextLogSetting
  ) extends zio.aws.lexmodelsv2.model.TextLogSetting.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val destination
        : zio.aws.lexmodelsv2.model.TextLogDestination.ReadOnly =
      zio.aws.lexmodelsv2.model.TextLogDestination.wrap(impl.destination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TextLogSetting
  ): zio.aws.lexmodelsv2.model.TextLogSetting.ReadOnly = new Wrapper(impl)
}
