package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  BotAliasId,
  Description,
  BotVersion,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateBotAliasRequest(
    botAliasId: BotAliasId,
    botAliasName: Name,
    description: Optional[Description] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    botAliasLocaleSettings: Optional[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings]
    ] = Optional.Absent,
    conversationLogSettings: Optional[
      zio.aws.lexmodelsv2.model.ConversationLogSettings
    ] = Optional.Absent,
    sentimentAnalysisSettings: Optional[
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings
    ] = Optional.Absent,
    botId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest = {
    import UpdateBotAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest
      .builder()
      .botAliasId(BotAliasId.unwrap(botAliasId): java.lang.String)
      .botAliasName(Name.unwrap(botAliasName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        botAliasLocaleSettings.map(value =>
          value
            .map({ case (key, value) =>
              (LocaleId.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.botAliasLocaleSettings)
      .optionallyWith(
        conversationLogSettings.map(value => value.buildAwsValue())
      )(_.conversationLogSettings)
      .optionallyWith(
        sentimentAnalysisSettings.map(value => value.buildAwsValue())
      )(_.sentimentAnalysisSettings)
      .botId(Id.unwrap(botId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateBotAliasRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateBotAliasRequest.wrap(buildAwsValue())
}
object UpdateBotAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateBotAliasRequest =
      zio.aws.lexmodelsv2.model.UpdateBotAliasRequest(
        botAliasId,
        botAliasName,
        description.map(value => value),
        botVersion.map(value => value),
        botAliasLocaleSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        conversationLogSettings.map(value => value.asEditable),
        sentimentAnalysisSettings.map(value => value.asEditable),
        botId
      )
    def botAliasId: BotAliasId
    def botAliasName: Name
    def description: Optional[Description]
    def botVersion: Optional[BotVersion]
    def botAliasLocaleSettings: Optional[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly]
    ]
    def conversationLogSettings
        : Optional[zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly]
    def sentimentAnalysisSettings
        : Optional[zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly]
    def botId: Id
    def getBotAliasId: ZIO[Any, Nothing, BotAliasId] = ZIO.succeed(botAliasId)
    def getBotAliasName: ZIO[Any, Nothing, Name] = ZIO.succeed(botAliasName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getBotAliasLocaleSettings: ZIO[Any, AwsError, Map[
      LocaleId,
      zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "botAliasLocaleSettings",
      botAliasLocaleSettings
    )
    def getConversationLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "conversationLogSettings",
      conversationLogSettings
    )
    def getSentimentAnalysisSettings: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sentimentAnalysisSettings",
      sentimentAnalysisSettings
    )
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest
  ) extends zio.aws.lexmodelsv2.model.UpdateBotAliasRequest.ReadOnly {
    override val botAliasId: BotAliasId =
      zio.aws.lexmodelsv2.model.primitives.BotAliasId(impl.botAliasId())
    override val botAliasName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.botAliasName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val botAliasLocaleSettings: Optional[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasLocaleSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.LocaleId(
              key
            ) -> zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.wrap(value)
          })
          .toMap
      )
    override val conversationLogSettings
        : Optional[zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationLogSettings())
        .map(value =>
          zio.aws.lexmodelsv2.model.ConversationLogSettings.wrap(value)
        )
    override val sentimentAnalysisSettings: Optional[
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sentimentAnalysisSettings())
      .map(value =>
        zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.wrap(value)
      )
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest
  ): zio.aws.lexmodelsv2.model.UpdateBotAliasRequest.ReadOnly = new Wrapper(
    impl
  )
}
