package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lexruntime.model.primitives.{UserId, BotAlias, BotName}
import scala.jdk.CollectionConverters.*
final case class DeleteSessionRequest(
    botName: BotName,
    botAlias: BotAlias,
    userId: UserId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest = {
    import DeleteSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest
      .builder()
      .botName(BotName.unwrap(botName): java.lang.String)
      .botAlias(BotAlias.unwrap(botAlias): java.lang.String)
      .userId(UserId.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.DeleteSessionRequest.ReadOnly =
    zio.aws.lexruntime.model.DeleteSessionRequest.wrap(buildAwsValue())
}
object DeleteSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.DeleteSessionRequest =
      zio.aws.lexruntime.model.DeleteSessionRequest(botName, botAlias, userId)
    def botName: BotName
    def botAlias: BotAlias
    def userId: UserId
    def getBotName: ZIO[Any, Nothing, BotName] = ZIO.succeed(botName)
    def getBotAlias: ZIO[Any, Nothing, BotAlias] = ZIO.succeed(botAlias)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest
  ) extends zio.aws.lexruntime.model.DeleteSessionRequest.ReadOnly {
    override val botName: BotName =
      zio.aws.lexruntime.model.primitives.BotName(impl.botName())
    override val botAlias: BotAlias =
      zio.aws.lexruntime.model.primitives.BotAlias(impl.botAlias())
    override val userId: UserId =
      zio.aws.lexruntime.model.primitives.UserId(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest
  ): zio.aws.lexruntime.model.DeleteSessionRequest.ReadOnly = new Wrapper(impl)
}
