package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lexruntime.model.primitives.{UserId, BotAlias, BotName}
import scala.jdk.CollectionConverters.*
final case class DeleteSessionResponse(
    botName: Option[BotName] = None,
    botAlias: Option[BotAlias] = None,
    userId: Option[UserId] = None,
    sessionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse = {
    import DeleteSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse
      .builder()
      .optionallyWith(
        botName.map(value => BotName.unwrap(value): java.lang.String)
      )(_.botName)
      .optionallyWith(
        botAlias.map(value => BotAlias.unwrap(value): java.lang.String)
      )(_.botAlias)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.DeleteSessionResponse.ReadOnly =
    zio.aws.lexruntime.model.DeleteSessionResponse.wrap(buildAwsValue())
}
object DeleteSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.DeleteSessionResponse =
      zio.aws.lexruntime.model.DeleteSessionResponse(
        botName.map(value => value),
        botAlias.map(value => value),
        userId.map(value => value),
        sessionId.map(value => value)
      )
    def botName: Option[BotName]
    def botAlias: Option[BotAlias]
    def userId: Option[UserId]
    def sessionId: Option[String]
    def getBotName: ZIO[Any, AwsError, BotName] =
      AwsError.unwrapOptionField("botName", botName)
    def getBotAlias: ZIO[Any, AwsError, BotAlias] =
      AwsError.unwrapOptionField("botAlias", botAlias)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getSessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse
  ) extends zio.aws.lexruntime.model.DeleteSessionResponse.ReadOnly {
    override val botName: Option[BotName] = scala
      .Option(impl.botName())
      .map(value => zio.aws.lexruntime.model.primitives.BotName(value))
    override val botAlias: Option[BotAlias] = scala
      .Option(impl.botAlias())
      .map(value => zio.aws.lexruntime.model.primitives.BotAlias(value))
    override val userId: Option[UserId] = scala
      .Option(impl.userId())
      .map(value => zio.aws.lexruntime.model.primitives.UserId(value))
    override val sessionId: Option[String] =
      scala.Option(impl.sessionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse
  ): zio.aws.lexruntime.model.DeleteSessionResponse.ReadOnly = new Wrapper(impl)
}
