package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lexruntime.model.primitives.{Text, IntentName}
import scala.jdk.CollectionConverters.*
final case class DialogAction(
    `type`: zio.aws.lexruntime.model.DialogActionType,
    intentName: Option[IntentName] = None,
    slots: Option[Map[String, String]] = None,
    slotToElicit: Option[String] = None,
    fulfillmentState: Option[zio.aws.lexruntime.model.FulfillmentState] = None,
    message: Option[Text] = None,
    messageFormat: Option[zio.aws.lexruntime.model.MessageFormatType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.DialogAction = {
    import DialogAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.DialogAction
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        intentName.map(value => IntentName.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.slots)
      .optionallyWith(slotToElicit.map(value => value: java.lang.String))(
        _.slotToElicit
      )
      .optionallyWith(fulfillmentState.map(value => value.unwrap))(
        _.fulfillmentState
      )
      .optionallyWith(
        message.map(value => Text.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.DialogAction.ReadOnly =
    zio.aws.lexruntime.model.DialogAction.wrap(buildAwsValue())
}
object DialogAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.DialogAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.DialogAction =
      zio.aws.lexruntime.model.DialogAction(
        `type`,
        intentName.map(value => value),
        slots.map(value => value),
        slotToElicit.map(value => value),
        fulfillmentState.map(value => value),
        message.map(value => value),
        messageFormat.map(value => value)
      )
    def `type`: zio.aws.lexruntime.model.DialogActionType
    def intentName: Option[IntentName]
    def slots: Option[Map[String, String]]
    def slotToElicit: Option[String]
    def fulfillmentState: Option[zio.aws.lexruntime.model.FulfillmentState]
    def message: Option[Text]
    def messageFormat: Option[zio.aws.lexruntime.model.MessageFormatType]
    def getType: ZIO[Any, Nothing, zio.aws.lexruntime.model.DialogActionType] =
      ZIO.succeed(`type`)
    def getIntentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getSlots: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("slots", slots)
    def getSlotToElicit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicit)
    def getFulfillmentState
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.FulfillmentState] =
      AwsError.unwrapOptionField("fulfillmentState", fulfillmentState)
    def getMessage: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("message", message)
    def getMessageFormat
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.MessageFormatType] =
      AwsError.unwrapOptionField("messageFormat", messageFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.DialogAction
  ) extends zio.aws.lexruntime.model.DialogAction.ReadOnly {
    override val `type`: zio.aws.lexruntime.model.DialogActionType =
      zio.aws.lexruntime.model.DialogActionType.wrap(impl.`type`())
    override val intentName: Option[IntentName] = scala
      .Option(impl.intentName())
      .map(value => zio.aws.lexruntime.model.primitives.IntentName(value))
    override val slots: Option[Map[String, String]] = scala
      .Option(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val slotToElicit: Option[String] =
      scala.Option(impl.slotToElicit()).map(value => value: String)
    override val fulfillmentState
        : Option[zio.aws.lexruntime.model.FulfillmentState] = scala
      .Option(impl.fulfillmentState())
      .map(value => zio.aws.lexruntime.model.FulfillmentState.wrap(value))
    override val message: Option[Text] = scala
      .Option(impl.message())
      .map(value => zio.aws.lexruntime.model.primitives.Text(value))
    override val messageFormat
        : Option[zio.aws.lexruntime.model.MessageFormatType] = scala
      .Option(impl.messageFormat())
      .map(value => zio.aws.lexruntime.model.MessageFormatType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.DialogAction
  ): zio.aws.lexruntime.model.DialogAction.ReadOnly = new Wrapper(impl)
}
