package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lexruntime.model.primitives.{
  StringUrlWithLength,
  StringWithLength
}
import scala.jdk.CollectionConverters.*
final case class GenericAttachment(
    title: Option[StringWithLength] = None,
    subTitle: Option[StringWithLength] = None,
    attachmentLinkUrl: Option[StringUrlWithLength] = None,
    imageUrl: Option[StringUrlWithLength] = None,
    buttons: Option[Iterable[zio.aws.lexruntime.model.Button]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.GenericAttachment = {
    import GenericAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.GenericAttachment
      .builder()
      .optionallyWith(
        title.map(value => StringWithLength.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        subTitle.map(value => StringWithLength.unwrap(value): java.lang.String)
      )(_.subTitle)
      .optionallyWith(
        attachmentLinkUrl.map(value =>
          StringUrlWithLength.unwrap(value): java.lang.String
        )
      )(_.attachmentLinkUrl)
      .optionallyWith(
        imageUrl.map(value =>
          StringUrlWithLength.unwrap(value): java.lang.String
        )
      )(_.imageUrl)
      .optionallyWith(
        buttons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buttons)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.GenericAttachment.ReadOnly =
    zio.aws.lexruntime.model.GenericAttachment.wrap(buildAwsValue())
}
object GenericAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.GenericAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.GenericAttachment =
      zio.aws.lexruntime.model.GenericAttachment(
        title.map(value => value),
        subTitle.map(value => value),
        attachmentLinkUrl.map(value => value),
        imageUrl.map(value => value),
        buttons.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def title: Option[StringWithLength]
    def subTitle: Option[StringWithLength]
    def attachmentLinkUrl: Option[StringUrlWithLength]
    def imageUrl: Option[StringUrlWithLength]
    def buttons: Option[List[zio.aws.lexruntime.model.Button.ReadOnly]]
    def getTitle: ZIO[Any, AwsError, StringWithLength] =
      AwsError.unwrapOptionField("title", title)
    def getSubTitle: ZIO[Any, AwsError, StringWithLength] =
      AwsError.unwrapOptionField("subTitle", subTitle)
    def getAttachmentLinkUrl: ZIO[Any, AwsError, StringUrlWithLength] =
      AwsError.unwrapOptionField("attachmentLinkUrl", attachmentLinkUrl)
    def getImageUrl: ZIO[Any, AwsError, StringUrlWithLength] =
      AwsError.unwrapOptionField("imageUrl", imageUrl)
    def getButtons
        : ZIO[Any, AwsError, List[zio.aws.lexruntime.model.Button.ReadOnly]] =
      AwsError.unwrapOptionField("buttons", buttons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.GenericAttachment
  ) extends zio.aws.lexruntime.model.GenericAttachment.ReadOnly {
    override val title: Option[StringWithLength] = scala
      .Option(impl.title())
      .map(value => zio.aws.lexruntime.model.primitives.StringWithLength(value))
    override val subTitle: Option[StringWithLength] = scala
      .Option(impl.subTitle())
      .map(value => zio.aws.lexruntime.model.primitives.StringWithLength(value))
    override val attachmentLinkUrl: Option[StringUrlWithLength] = scala
      .Option(impl.attachmentLinkUrl())
      .map(value =>
        zio.aws.lexruntime.model.primitives.StringUrlWithLength(value)
      )
    override val imageUrl: Option[StringUrlWithLength] = scala
      .Option(impl.imageUrl())
      .map(value =>
        zio.aws.lexruntime.model.primitives.StringUrlWithLength(value)
      )
    override val buttons
        : Option[List[zio.aws.lexruntime.model.Button.ReadOnly]] = scala
      .Option(impl.buttons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexruntime.model.Button.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.GenericAttachment
  ): zio.aws.lexruntime.model.GenericAttachment.ReadOnly = new Wrapper(impl)
}
