package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lexruntime.model.primitives.{
  IntentSummaryCheckpointLabel,
  UserId,
  BotAlias,
  BotName
}
import scala.jdk.CollectionConverters.*
final case class GetSessionRequest(
    botName: BotName,
    botAlias: BotAlias,
    userId: UserId,
    checkpointLabelFilter: Option[IntentSummaryCheckpointLabel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.GetSessionRequest = {
    import GetSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.GetSessionRequest
      .builder()
      .botName(BotName.unwrap(botName): java.lang.String)
      .botAlias(BotAlias.unwrap(botAlias): java.lang.String)
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        checkpointLabelFilter.map(value =>
          IntentSummaryCheckpointLabel.unwrap(value): java.lang.String
        )
      )(_.checkpointLabelFilter)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.GetSessionRequest.ReadOnly =
    zio.aws.lexruntime.model.GetSessionRequest.wrap(buildAwsValue())
}
object GetSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.GetSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.GetSessionRequest =
      zio.aws.lexruntime.model.GetSessionRequest(
        botName,
        botAlias,
        userId,
        checkpointLabelFilter.map(value => value)
      )
    def botName: BotName
    def botAlias: BotAlias
    def userId: UserId
    def checkpointLabelFilter: Option[IntentSummaryCheckpointLabel]
    def getBotName: ZIO[Any, Nothing, BotName] = ZIO.succeed(botName)
    def getBotAlias: ZIO[Any, Nothing, BotAlias] = ZIO.succeed(botAlias)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getCheckpointLabelFilter
        : ZIO[Any, AwsError, IntentSummaryCheckpointLabel] =
      AwsError.unwrapOptionField("checkpointLabelFilter", checkpointLabelFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.GetSessionRequest
  ) extends zio.aws.lexruntime.model.GetSessionRequest.ReadOnly {
    override val botName: BotName =
      zio.aws.lexruntime.model.primitives.BotName(impl.botName())
    override val botAlias: BotAlias =
      zio.aws.lexruntime.model.primitives.BotAlias(impl.botAlias())
    override val userId: UserId =
      zio.aws.lexruntime.model.primitives.UserId(impl.userId())
    override val checkpointLabelFilter: Option[IntentSummaryCheckpointLabel] =
      scala
        .Option(impl.checkpointLabelFilter())
        .map(value =>
          zio.aws.lexruntime.model.primitives
            .IntentSummaryCheckpointLabel(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.GetSessionRequest
  ): zio.aws.lexruntime.model.GetSessionRequest.ReadOnly = new Wrapper(impl)
}
