package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lexruntime.model.primitives.{
  IntentSummaryCheckpointLabel,
  IntentName
}
import scala.jdk.CollectionConverters.*
final case class IntentSummary(
    intentName: Option[IntentName] = None,
    checkpointLabel: Option[IntentSummaryCheckpointLabel] = None,
    slots: Option[Map[String, String]] = None,
    confirmationStatus: Option[zio.aws.lexruntime.model.ConfirmationStatus] =
      None,
    dialogActionType: zio.aws.lexruntime.model.DialogActionType,
    fulfillmentState: Option[zio.aws.lexruntime.model.FulfillmentState] = None,
    slotToElicit: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.IntentSummary = {
    import IntentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.IntentSummary
      .builder()
      .optionallyWith(
        intentName.map(value => IntentName.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(
        checkpointLabel.map(value =>
          IntentSummaryCheckpointLabel.unwrap(value): java.lang.String
        )
      )(_.checkpointLabel)
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.slots)
      .optionallyWith(confirmationStatus.map(value => value.unwrap))(
        _.confirmationStatus
      )
      .dialogActionType(dialogActionType.unwrap)
      .optionallyWith(fulfillmentState.map(value => value.unwrap))(
        _.fulfillmentState
      )
      .optionallyWith(slotToElicit.map(value => value: java.lang.String))(
        _.slotToElicit
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.IntentSummary.ReadOnly =
    zio.aws.lexruntime.model.IntentSummary.wrap(buildAwsValue())
}
object IntentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.IntentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.IntentSummary =
      zio.aws.lexruntime.model.IntentSummary(
        intentName.map(value => value),
        checkpointLabel.map(value => value),
        slots.map(value => value),
        confirmationStatus.map(value => value),
        dialogActionType,
        fulfillmentState.map(value => value),
        slotToElicit.map(value => value)
      )
    def intentName: Option[IntentName]
    def checkpointLabel: Option[IntentSummaryCheckpointLabel]
    def slots: Option[Map[String, String]]
    def confirmationStatus: Option[zio.aws.lexruntime.model.ConfirmationStatus]
    def dialogActionType: zio.aws.lexruntime.model.DialogActionType
    def fulfillmentState: Option[zio.aws.lexruntime.model.FulfillmentState]
    def slotToElicit: Option[String]
    def getIntentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getCheckpointLabel: ZIO[Any, AwsError, IntentSummaryCheckpointLabel] =
      AwsError.unwrapOptionField("checkpointLabel", checkpointLabel)
    def getSlots: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("slots", slots)
    def getConfirmationStatus
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.ConfirmationStatus] =
      AwsError.unwrapOptionField("confirmationStatus", confirmationStatus)
    def getDialogActionType
        : ZIO[Any, Nothing, zio.aws.lexruntime.model.DialogActionType] =
      ZIO.succeed(dialogActionType)
    def getFulfillmentState
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.FulfillmentState] =
      AwsError.unwrapOptionField("fulfillmentState", fulfillmentState)
    def getSlotToElicit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.IntentSummary
  ) extends zio.aws.lexruntime.model.IntentSummary.ReadOnly {
    override val intentName: Option[IntentName] = scala
      .Option(impl.intentName())
      .map(value => zio.aws.lexruntime.model.primitives.IntentName(value))
    override val checkpointLabel: Option[IntentSummaryCheckpointLabel] = scala
      .Option(impl.checkpointLabel())
      .map(value =>
        zio.aws.lexruntime.model.primitives.IntentSummaryCheckpointLabel(value)
      )
    override val slots: Option[Map[String, String]] = scala
      .Option(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val confirmationStatus
        : Option[zio.aws.lexruntime.model.ConfirmationStatus] = scala
      .Option(impl.confirmationStatus())
      .map(value => zio.aws.lexruntime.model.ConfirmationStatus.wrap(value))
    override val dialogActionType: zio.aws.lexruntime.model.DialogActionType =
      zio.aws.lexruntime.model.DialogActionType.wrap(impl.dialogActionType())
    override val fulfillmentState
        : Option[zio.aws.lexruntime.model.FulfillmentState] = scala
      .Option(impl.fulfillmentState())
      .map(value => zio.aws.lexruntime.model.FulfillmentState.wrap(value))
    override val slotToElicit: Option[String] =
      scala.Option(impl.slotToElicit()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.IntentSummary
  ): zio.aws.lexruntime.model.IntentSummary.ReadOnly = new Wrapper(impl)
}
