package zio.aws.lexruntime.model
import scala.jdk.CollectionConverters.*
sealed trait MessageFormatType {
  def unwrap: software.amazon.awssdk.services.lexruntime.model.MessageFormatType
}
object MessageFormatType {
  def wrap(
      value: software.amazon.awssdk.services.lexruntime.model.MessageFormatType
  ): zio.aws.lexruntime.model.MessageFormatType = value match {
    case software.amazon.awssdk.services.lexruntime.model.MessageFormatType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.MessageFormatType.PLAIN_TEXT =>
      val r = PlainText
      r
    case software.amazon.awssdk.services.lexruntime.model.MessageFormatType.CUSTOM_PAYLOAD =>
      val r = CustomPayload
      r
    case software.amazon.awssdk.services.lexruntime.model.MessageFormatType.SSML =>
      val r = SSML
      r
    case software.amazon.awssdk.services.lexruntime.model.MessageFormatType.COMPOSITE =>
      val r = Composite
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexruntime.model.MessageFormatType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.MessageFormatType =
      software.amazon.awssdk.services.lexruntime.model.MessageFormatType.UNKNOWN_TO_SDK_VERSION
  }
  case object PlainText extends zio.aws.lexruntime.model.MessageFormatType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.MessageFormatType =
      software.amazon.awssdk.services.lexruntime.model.MessageFormatType.PLAIN_TEXT
  }
  case object CustomPayload extends zio.aws.lexruntime.model.MessageFormatType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.MessageFormatType =
      software.amazon.awssdk.services.lexruntime.model.MessageFormatType.CUSTOM_PAYLOAD
  }
  case object SSML extends zio.aws.lexruntime.model.MessageFormatType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.MessageFormatType =
      software.amazon.awssdk.services.lexruntime.model.MessageFormatType.SSML
  }
  case object Composite extends zio.aws.lexruntime.model.MessageFormatType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.MessageFormatType =
      software.amazon.awssdk.services.lexruntime.model.MessageFormatType.COMPOSITE
  }
}
