package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lexruntime.model.primitives.{
  HttpContentType,
  UserId,
  Accept,
  BotAlias,
  AttributesString,
  ActiveContextsString,
  BotName
}
import scala.jdk.CollectionConverters.*
final case class PostContentRequest(
    botName: BotName,
    botAlias: BotAlias,
    userId: UserId,
    sessionAttributes: Option[AttributesString] = None,
    requestAttributes: Option[AttributesString] = None,
    contentType: HttpContentType,
    accept: Option[Accept] = None,
    activeContexts: Option[ActiveContextsString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PostContentRequest = {
    import PostContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostContentRequest
      .builder()
      .botName(BotName.unwrap(botName): java.lang.String)
      .botAlias(BotAlias.unwrap(botAlias): java.lang.String)
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        sessionAttributes.map(value =>
          AttributesString.unwrap(value): java.lang.String
        )
      )(_.sessionAttributes)
      .optionallyWith(
        requestAttributes.map(value =>
          AttributesString.unwrap(value): java.lang.String
        )
      )(_.requestAttributes)
      .contentType(HttpContentType.unwrap(contentType): java.lang.String)
      .optionallyWith(
        accept.map(value => Accept.unwrap(value): java.lang.String)
      )(_.accept)
      .optionallyWith(
        activeContexts.map(value =>
          ActiveContextsString.unwrap(value): java.lang.String
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.PostContentRequest.ReadOnly =
    zio.aws.lexruntime.model.PostContentRequest.wrap(buildAwsValue())
}
object PostContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PostContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.PostContentRequest =
      zio.aws.lexruntime.model.PostContentRequest(
        botName,
        botAlias,
        userId,
        sessionAttributes.map(value => value),
        requestAttributes.map(value => value),
        contentType,
        accept.map(value => value),
        activeContexts.map(value => value)
      )
    def botName: BotName
    def botAlias: BotAlias
    def userId: UserId
    def sessionAttributes: Option[AttributesString]
    def requestAttributes: Option[AttributesString]
    def contentType: HttpContentType
    def accept: Option[Accept]
    def activeContexts: Option[ActiveContextsString]
    def getBotName: ZIO[Any, Nothing, BotName] = ZIO.succeed(botName)
    def getBotAlias: ZIO[Any, Nothing, BotAlias] = ZIO.succeed(botAlias)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getSessionAttributes: ZIO[Any, AwsError, AttributesString] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
    def getRequestAttributes: ZIO[Any, AwsError, AttributesString] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
    def getContentType: ZIO[Any, Nothing, HttpContentType] =
      ZIO.succeed(contentType)
    def getAccept: ZIO[Any, AwsError, Accept] =
      AwsError.unwrapOptionField("accept", accept)
    def getActiveContexts: ZIO[Any, AwsError, ActiveContextsString] =
      AwsError.unwrapOptionField("activeContexts", activeContexts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PostContentRequest
  ) extends zio.aws.lexruntime.model.PostContentRequest.ReadOnly {
    override val botName: BotName =
      zio.aws.lexruntime.model.primitives.BotName(impl.botName())
    override val botAlias: BotAlias =
      zio.aws.lexruntime.model.primitives.BotAlias(impl.botAlias())
    override val userId: UserId =
      zio.aws.lexruntime.model.primitives.UserId(impl.userId())
    override val sessionAttributes: Option[AttributesString] = scala
      .Option(impl.sessionAttributes())
      .map(value => zio.aws.lexruntime.model.primitives.AttributesString(value))
    override val requestAttributes: Option[AttributesString] = scala
      .Option(impl.requestAttributes())
      .map(value => zio.aws.lexruntime.model.primitives.AttributesString(value))
    override val contentType: HttpContentType =
      zio.aws.lexruntime.model.primitives.HttpContentType(impl.contentType())
    override val accept: Option[Accept] = scala
      .Option(impl.accept())
      .map(value => zio.aws.lexruntime.model.primitives.Accept(value))
    override val activeContexts: Option[ActiveContextsString] = scala
      .Option(impl.activeContexts())
      .map(value =>
        zio.aws.lexruntime.model.primitives.ActiveContextsString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PostContentRequest
  ): zio.aws.lexruntime.model.PostContentRequest.ReadOnly = new Wrapper(impl)
}
