package zio.aws.lexruntime.model
import scala.jdk.CollectionConverters.*
sealed trait ContentType {
  def unwrap: software.amazon.awssdk.services.lexruntime.model.ContentType
}
object ContentType {
  def wrap(
      value: software.amazon.awssdk.services.lexruntime.model.ContentType
  ): zio.aws.lexruntime.model.ContentType = value match {
    case software.amazon.awssdk.services.lexruntime.model.ContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.ContentType.APPLICATION_VND_AMAZONAWS_CARD_GENERIC =>
      val r = `application/vnd.amazonaws.card.generic`
      r
  }
  case object unknownToSdkVersion extends zio.aws.lexruntime.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.ContentType =
      software.amazon.awssdk.services.lexruntime.model.ContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object `application/vnd.amazonaws.card.generic`
      extends zio.aws.lexruntime.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.ContentType =
      software.amazon.awssdk.services.lexruntime.model.ContentType.APPLICATION_VND_AMAZONAWS_CARD_GENERIC
  }
}
