package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lexruntime.model.primitives.{
  StringUrlWithLength,
  StringWithLength
}
import scala.jdk.CollectionConverters.*
final case class GenericAttachment(
    title: Optional[StringWithLength] = Optional.Absent,
    subTitle: Optional[StringWithLength] = Optional.Absent,
    attachmentLinkUrl: Optional[StringUrlWithLength] = Optional.Absent,
    imageUrl: Optional[StringUrlWithLength] = Optional.Absent,
    buttons: Optional[Iterable[zio.aws.lexruntime.model.Button]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.GenericAttachment = {
    import GenericAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.GenericAttachment
      .builder()
      .optionallyWith(
        title.map(value => StringWithLength.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        subTitle.map(value => StringWithLength.unwrap(value): java.lang.String)
      )(_.subTitle)
      .optionallyWith(
        attachmentLinkUrl.map(value =>
          StringUrlWithLength.unwrap(value): java.lang.String
        )
      )(_.attachmentLinkUrl)
      .optionallyWith(
        imageUrl.map(value =>
          StringUrlWithLength.unwrap(value): java.lang.String
        )
      )(_.imageUrl)
      .optionallyWith(
        buttons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buttons)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.GenericAttachment.ReadOnly =
    zio.aws.lexruntime.model.GenericAttachment.wrap(buildAwsValue())
}
object GenericAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.GenericAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.GenericAttachment =
      zio.aws.lexruntime.model.GenericAttachment(
        title.map(value => value),
        subTitle.map(value => value),
        attachmentLinkUrl.map(value => value),
        imageUrl.map(value => value),
        buttons.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def title: Optional[StringWithLength]
    def subTitle: Optional[StringWithLength]
    def attachmentLinkUrl: Optional[StringUrlWithLength]
    def imageUrl: Optional[StringUrlWithLength]
    def buttons: Optional[List[zio.aws.lexruntime.model.Button.ReadOnly]]
    def getTitle: ZIO[Any, AwsError, StringWithLength] =
      AwsError.unwrapOptionField("title", title)
    def getSubTitle: ZIO[Any, AwsError, StringWithLength] =
      AwsError.unwrapOptionField("subTitle", subTitle)
    def getAttachmentLinkUrl: ZIO[Any, AwsError, StringUrlWithLength] =
      AwsError.unwrapOptionField("attachmentLinkUrl", attachmentLinkUrl)
    def getImageUrl: ZIO[Any, AwsError, StringUrlWithLength] =
      AwsError.unwrapOptionField("imageUrl", imageUrl)
    def getButtons
        : ZIO[Any, AwsError, List[zio.aws.lexruntime.model.Button.ReadOnly]] =
      AwsError.unwrapOptionField("buttons", buttons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.GenericAttachment
  ) extends zio.aws.lexruntime.model.GenericAttachment.ReadOnly {
    override val title: Optional[StringWithLength] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.lexruntime.model.primitives.StringWithLength(value))
    override val subTitle: Optional[StringWithLength] = zio.aws.core.internal
      .optionalFromNullable(impl.subTitle())
      .map(value => zio.aws.lexruntime.model.primitives.StringWithLength(value))
    override val attachmentLinkUrl: Optional[StringUrlWithLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachmentLinkUrl())
        .map(value =>
          zio.aws.lexruntime.model.primitives.StringUrlWithLength(value)
        )
    override val imageUrl: Optional[StringUrlWithLength] = zio.aws.core.internal
      .optionalFromNullable(impl.imageUrl())
      .map(value =>
        zio.aws.lexruntime.model.primitives.StringUrlWithLength(value)
      )
    override val buttons
        : Optional[List[zio.aws.lexruntime.model.Button.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buttons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntime.model.Button.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.GenericAttachment
  ): zio.aws.lexruntime.model.GenericAttachment.ReadOnly = new Wrapper(impl)
}
