package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lexruntime.model.primitives.{
  IntentSummaryCheckpointLabel,
  IntentName
}
import scala.jdk.CollectionConverters.*
final case class IntentSummary(
    intentName: Optional[IntentName] = Optional.Absent,
    checkpointLabel: Optional[IntentSummaryCheckpointLabel] = Optional.Absent,
    slots: Optional[Map[String, String]] = Optional.Absent,
    confirmationStatus: Optional[zio.aws.lexruntime.model.ConfirmationStatus] =
      Optional.Absent,
    dialogActionType: zio.aws.lexruntime.model.DialogActionType,
    fulfillmentState: Optional[zio.aws.lexruntime.model.FulfillmentState] =
      Optional.Absent,
    slotToElicit: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.IntentSummary = {
    import IntentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.IntentSummary
      .builder()
      .optionallyWith(
        intentName.map(value => IntentName.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(
        checkpointLabel.map(value =>
          IntentSummaryCheckpointLabel.unwrap(value): java.lang.String
        )
      )(_.checkpointLabel)
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.slots)
      .optionallyWith(confirmationStatus.map(value => value.unwrap))(
        _.confirmationStatus
      )
      .dialogActionType(dialogActionType.unwrap)
      .optionallyWith(fulfillmentState.map(value => value.unwrap))(
        _.fulfillmentState
      )
      .optionallyWith(slotToElicit.map(value => value: java.lang.String))(
        _.slotToElicit
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.IntentSummary.ReadOnly =
    zio.aws.lexruntime.model.IntentSummary.wrap(buildAwsValue())
}
object IntentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.IntentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.IntentSummary =
      zio.aws.lexruntime.model.IntentSummary(
        intentName.map(value => value),
        checkpointLabel.map(value => value),
        slots.map(value => value),
        confirmationStatus.map(value => value),
        dialogActionType,
        fulfillmentState.map(value => value),
        slotToElicit.map(value => value)
      )
    def intentName: Optional[IntentName]
    def checkpointLabel: Optional[IntentSummaryCheckpointLabel]
    def slots: Optional[Map[String, String]]
    def confirmationStatus
        : Optional[zio.aws.lexruntime.model.ConfirmationStatus]
    def dialogActionType: zio.aws.lexruntime.model.DialogActionType
    def fulfillmentState: Optional[zio.aws.lexruntime.model.FulfillmentState]
    def slotToElicit: Optional[String]
    def getIntentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getCheckpointLabel: ZIO[Any, AwsError, IntentSummaryCheckpointLabel] =
      AwsError.unwrapOptionField("checkpointLabel", checkpointLabel)
    def getSlots: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("slots", slots)
    def getConfirmationStatus
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.ConfirmationStatus] =
      AwsError.unwrapOptionField("confirmationStatus", confirmationStatus)
    def getDialogActionType
        : ZIO[Any, Nothing, zio.aws.lexruntime.model.DialogActionType] =
      ZIO.succeed(dialogActionType)
    def getFulfillmentState
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.FulfillmentState] =
      AwsError.unwrapOptionField("fulfillmentState", fulfillmentState)
    def getSlotToElicit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.IntentSummary
  ) extends zio.aws.lexruntime.model.IntentSummary.ReadOnly {
    override val intentName: Optional[IntentName] = zio.aws.core.internal
      .optionalFromNullable(impl.intentName())
      .map(value => zio.aws.lexruntime.model.primitives.IntentName(value))
    override val checkpointLabel: Optional[IntentSummaryCheckpointLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkpointLabel())
        .map(value =>
          zio.aws.lexruntime.model.primitives
            .IntentSummaryCheckpointLabel(value)
        )
    override val slots: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val confirmationStatus
        : Optional[zio.aws.lexruntime.model.ConfirmationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.confirmationStatus())
        .map(value => zio.aws.lexruntime.model.ConfirmationStatus.wrap(value))
    override val dialogActionType: zio.aws.lexruntime.model.DialogActionType =
      zio.aws.lexruntime.model.DialogActionType.wrap(impl.dialogActionType())
    override val fulfillmentState
        : Optional[zio.aws.lexruntime.model.FulfillmentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fulfillmentState())
        .map(value => zio.aws.lexruntime.model.FulfillmentState.wrap(value))
    override val slotToElicit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slotToElicit())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.IntentSummary
  ): zio.aws.lexruntime.model.IntentSummary.ReadOnly = new Wrapper(impl)
}
