package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lexruntime.model.primitives.{
  HttpContentType,
  Text,
  SensitiveStringUnbounded,
  IntentName,
  BotVersion,
  ActiveContextsString,
  SensitiveString
}
import scala.jdk.CollectionConverters.*
final case class PostContentResponse(
    contentType: Optional[HttpContentType] = Optional.Absent,
    intentName: Optional[IntentName] = Optional.Absent,
    nluIntentConfidence: Optional[String] = Optional.Absent,
    alternativeIntents: Optional[String] = Optional.Absent,
    slots: Optional[String] = Optional.Absent,
    sessionAttributes: Optional[String] = Optional.Absent,
    sentimentResponse: Optional[String] = Optional.Absent,
    message: Optional[Text] = Optional.Absent,
    encodedMessage: Optional[SensitiveString] = Optional.Absent,
    messageFormat: Optional[zio.aws.lexruntime.model.MessageFormatType] =
      Optional.Absent,
    dialogState: Optional[zio.aws.lexruntime.model.DialogState] =
      Optional.Absent,
    slotToElicit: Optional[String] = Optional.Absent,
    inputTranscript: Optional[String] = Optional.Absent,
    encodedInputTranscript: Optional[SensitiveStringUnbounded] =
      Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    sessionId: Optional[String] = Optional.Absent,
    activeContexts: Optional[ActiveContextsString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PostContentResponse = {
    import PostContentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostContentResponse
      .builder()
      .optionallyWith(
        contentType.map(value =>
          HttpContentType.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .optionallyWith(
        intentName.map(value => IntentName.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(
        nluIntentConfidence.map(value => value: java.lang.String)
      )(_.nluIntentConfidence)
      .optionallyWith(alternativeIntents.map(value => value: java.lang.String))(
        _.alternativeIntents
      )
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(sessionAttributes.map(value => value: java.lang.String))(
        _.sessionAttributes
      )
      .optionallyWith(sentimentResponse.map(value => value: java.lang.String))(
        _.sentimentResponse
      )
      .optionallyWith(
        message.map(value => Text.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        encodedMessage.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.encodedMessage)
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .optionallyWith(dialogState.map(value => value.unwrap))(_.dialogState)
      .optionallyWith(slotToElicit.map(value => value: java.lang.String))(
        _.slotToElicit
      )
      .optionallyWith(inputTranscript.map(value => value: java.lang.String))(
        _.inputTranscript
      )
      .optionallyWith(
        encodedInputTranscript.map(value =>
          SensitiveStringUnbounded.unwrap(value): java.lang.String
        )
      )(_.encodedInputTranscript)
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(
        activeContexts.map(value =>
          ActiveContextsString.unwrap(value): java.lang.String
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.PostContentResponse.ReadOnly =
    zio.aws.lexruntime.model.PostContentResponse.wrap(buildAwsValue())
}
object PostContentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PostContentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.PostContentResponse =
      zio.aws.lexruntime.model.PostContentResponse(
        contentType.map(value => value),
        intentName.map(value => value),
        nluIntentConfidence.map(value => value),
        alternativeIntents.map(value => value),
        slots.map(value => value),
        sessionAttributes.map(value => value),
        sentimentResponse.map(value => value),
        message.map(value => value),
        encodedMessage.map(value => value),
        messageFormat.map(value => value),
        dialogState.map(value => value),
        slotToElicit.map(value => value),
        inputTranscript.map(value => value),
        encodedInputTranscript.map(value => value),
        botVersion.map(value => value),
        sessionId.map(value => value),
        activeContexts.map(value => value)
      )
    def contentType: Optional[HttpContentType]
    def intentName: Optional[IntentName]
    def nluIntentConfidence: Optional[String]
    def alternativeIntents: Optional[String]
    def slots: Optional[String]
    def sessionAttributes: Optional[String]
    def sentimentResponse: Optional[String]
    def message: Optional[Text]
    def encodedMessage: Optional[SensitiveString]
    def messageFormat: Optional[zio.aws.lexruntime.model.MessageFormatType]
    def dialogState: Optional[zio.aws.lexruntime.model.DialogState]
    def slotToElicit: Optional[String]
    def inputTranscript: Optional[String]
    def encodedInputTranscript: Optional[SensitiveStringUnbounded]
    def botVersion: Optional[BotVersion]
    def sessionId: Optional[String]
    def activeContexts: Optional[ActiveContextsString]
    def getContentType: ZIO[Any, AwsError, HttpContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getIntentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getNluIntentConfidence: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nluIntentConfidence", nluIntentConfidence)
    def getAlternativeIntents: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("alternativeIntents", alternativeIntents)
    def getSlots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slots)
    def getSessionAttributes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
    def getSentimentResponse: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sentimentResponse", sentimentResponse)
    def getMessage: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("message", message)
    def getEncodedMessage: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("encodedMessage", encodedMessage)
    def getMessageFormat
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.MessageFormatType] =
      AwsError.unwrapOptionField("messageFormat", messageFormat)
    def getDialogState
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.DialogState] =
      AwsError.unwrapOptionField("dialogState", dialogState)
    def getSlotToElicit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicit)
    def getInputTranscript: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("inputTranscript", inputTranscript)
    def getEncodedInputTranscript
        : ZIO[Any, AwsError, SensitiveStringUnbounded] = AwsError
      .unwrapOptionField("encodedInputTranscript", encodedInputTranscript)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getSessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getActiveContexts: ZIO[Any, AwsError, ActiveContextsString] =
      AwsError.unwrapOptionField("activeContexts", activeContexts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PostContentResponse
  ) extends zio.aws.lexruntime.model.PostContentResponse.ReadOnly {
    override val contentType: Optional[HttpContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.lexruntime.model.primitives.HttpContentType(value))
    override val intentName: Optional[IntentName] = zio.aws.core.internal
      .optionalFromNullable(impl.intentName())
      .map(value => zio.aws.lexruntime.model.primitives.IntentName(value))
    override val nluIntentConfidence: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nluIntentConfidence())
      .map(value => value: String)
    override val alternativeIntents: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.alternativeIntents())
      .map(value => value: String)
    override val slots: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slots())
      .map(value => value: String)
    override val sessionAttributes: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionAttributes())
      .map(value => value: String)
    override val sentimentResponse: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sentimentResponse())
      .map(value => value: String)
    override val message: Optional[Text] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.lexruntime.model.primitives.Text(value))
    override val encodedMessage: Optional[SensitiveString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encodedMessage())
        .map(value =>
          zio.aws.lexruntime.model.primitives.SensitiveString(value)
        )
    override val messageFormat
        : Optional[zio.aws.lexruntime.model.MessageFormatType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageFormat())
        .map(value => zio.aws.lexruntime.model.MessageFormatType.wrap(value))
    override val dialogState: Optional[zio.aws.lexruntime.model.DialogState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dialogState())
        .map(value => zio.aws.lexruntime.model.DialogState.wrap(value))
    override val slotToElicit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slotToElicit())
      .map(value => value: String)
    override val inputTranscript: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.inputTranscript())
      .map(value => value: String)
    override val encodedInputTranscript: Optional[SensitiveStringUnbounded] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encodedInputTranscript())
        .map(value =>
          zio.aws.lexruntime.model.primitives.SensitiveStringUnbounded(value)
        )
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexruntime.model.primitives.BotVersion(value))
    override val sessionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => value: String)
    override val activeContexts: Optional[ActiveContextsString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeContexts())
        .map(value =>
          zio.aws.lexruntime.model.primitives.ActiveContextsString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PostContentResponse
  ): zio.aws.lexruntime.model.PostContentResponse.ReadOnly = new Wrapper(impl)
}
