package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lexruntime.model.primitives.{BotVersion, Text, IntentName}
import scala.jdk.CollectionConverters.*
final case class PostTextResponse(
    intentName: Optional[IntentName] = Optional.Absent,
    nluIntentConfidence: Optional[zio.aws.lexruntime.model.IntentConfidence] =
      Optional.Absent,
    alternativeIntents: Optional[
      Iterable[zio.aws.lexruntime.model.PredictedIntent]
    ] = Optional.Absent,
    slots: Optional[Map[String, String]] = Optional.Absent,
    sessionAttributes: Optional[Map[String, String]] = Optional.Absent,
    message: Optional[Text] = Optional.Absent,
    sentimentResponse: Optional[zio.aws.lexruntime.model.SentimentResponse] =
      Optional.Absent,
    messageFormat: Optional[zio.aws.lexruntime.model.MessageFormatType] =
      Optional.Absent,
    dialogState: Optional[zio.aws.lexruntime.model.DialogState] =
      Optional.Absent,
    slotToElicit: Optional[String] = Optional.Absent,
    responseCard: Optional[zio.aws.lexruntime.model.ResponseCard] =
      Optional.Absent,
    sessionId: Optional[String] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    activeContexts: Optional[Iterable[zio.aws.lexruntime.model.ActiveContext]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PostTextResponse = {
    import PostTextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostTextResponse
      .builder()
      .optionallyWith(
        intentName.map(value => IntentName.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(nluIntentConfidence.map(value => value.buildAwsValue()))(
        _.nluIntentConfidence
      )
      .optionallyWith(
        alternativeIntents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alternativeIntents)
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.slots)
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .optionallyWith(
        message.map(value => Text.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(sentimentResponse.map(value => value.buildAwsValue()))(
        _.sentimentResponse
      )
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .optionallyWith(dialogState.map(value => value.unwrap))(_.dialogState)
      .optionallyWith(slotToElicit.map(value => value: java.lang.String))(
        _.slotToElicit
      )
      .optionallyWith(responseCard.map(value => value.buildAwsValue()))(
        _.responseCard
      )
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.PostTextResponse.ReadOnly =
    zio.aws.lexruntime.model.PostTextResponse.wrap(buildAwsValue())
}
object PostTextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PostTextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.PostTextResponse =
      zio.aws.lexruntime.model.PostTextResponse(
        intentName.map(value => value),
        nluIntentConfidence.map(value => value.asEditable),
        alternativeIntents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        slots.map(value => value),
        sessionAttributes.map(value => value),
        message.map(value => value),
        sentimentResponse.map(value => value.asEditable),
        messageFormat.map(value => value),
        dialogState.map(value => value),
        slotToElicit.map(value => value),
        responseCard.map(value => value.asEditable),
        sessionId.map(value => value),
        botVersion.map(value => value),
        activeContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def intentName: Optional[IntentName]
    def nluIntentConfidence
        : Optional[zio.aws.lexruntime.model.IntentConfidence.ReadOnly]
    def alternativeIntents
        : Optional[List[zio.aws.lexruntime.model.PredictedIntent.ReadOnly]]
    def slots: Optional[Map[String, String]]
    def sessionAttributes: Optional[Map[String, String]]
    def message: Optional[Text]
    def sentimentResponse
        : Optional[zio.aws.lexruntime.model.SentimentResponse.ReadOnly]
    def messageFormat: Optional[zio.aws.lexruntime.model.MessageFormatType]
    def dialogState: Optional[zio.aws.lexruntime.model.DialogState]
    def slotToElicit: Optional[String]
    def responseCard: Optional[zio.aws.lexruntime.model.ResponseCard.ReadOnly]
    def sessionId: Optional[String]
    def botVersion: Optional[BotVersion]
    def activeContexts
        : Optional[List[zio.aws.lexruntime.model.ActiveContext.ReadOnly]]
    def getIntentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getNluIntentConfidence: ZIO[
      Any,
      AwsError,
      zio.aws.lexruntime.model.IntentConfidence.ReadOnly
    ] = AwsError.unwrapOptionField("nluIntentConfidence", nluIntentConfidence)
    def getAlternativeIntents: ZIO[Any, AwsError, List[
      zio.aws.lexruntime.model.PredictedIntent.ReadOnly
    ]] = AwsError.unwrapOptionField("alternativeIntents", alternativeIntents)
    def getSlots: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("slots", slots)
    def getSessionAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
    def getMessage: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("message", message)
    def getSentimentResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexruntime.model.SentimentResponse.ReadOnly
    ] = AwsError.unwrapOptionField("sentimentResponse", sentimentResponse)
    def getMessageFormat
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.MessageFormatType] =
      AwsError.unwrapOptionField("messageFormat", messageFormat)
    def getDialogState
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.DialogState] =
      AwsError.unwrapOptionField("dialogState", dialogState)
    def getSlotToElicit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicit)
    def getResponseCard
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.ResponseCard.ReadOnly] =
      AwsError.unwrapOptionField("responseCard", responseCard)
    def getSessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getActiveContexts: ZIO[Any, AwsError, List[
      zio.aws.lexruntime.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContexts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PostTextResponse
  ) extends zio.aws.lexruntime.model.PostTextResponse.ReadOnly {
    override val intentName: Optional[IntentName] = zio.aws.core.internal
      .optionalFromNullable(impl.intentName())
      .map(value => zio.aws.lexruntime.model.primitives.IntentName(value))
    override val nluIntentConfidence
        : Optional[zio.aws.lexruntime.model.IntentConfidence.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nluIntentConfidence())
        .map(value => zio.aws.lexruntime.model.IntentConfidence.wrap(value))
    override val alternativeIntents
        : Optional[List[zio.aws.lexruntime.model.PredictedIntent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alternativeIntents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntime.model.PredictedIntent.wrap(item)
          }.toList
        )
    override val slots: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val sessionAttributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionAttributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val message: Optional[Text] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.lexruntime.model.primitives.Text(value))
    override val sentimentResponse
        : Optional[zio.aws.lexruntime.model.SentimentResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sentimentResponse())
        .map(value => zio.aws.lexruntime.model.SentimentResponse.wrap(value))
    override val messageFormat
        : Optional[zio.aws.lexruntime.model.MessageFormatType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageFormat())
        .map(value => zio.aws.lexruntime.model.MessageFormatType.wrap(value))
    override val dialogState: Optional[zio.aws.lexruntime.model.DialogState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dialogState())
        .map(value => zio.aws.lexruntime.model.DialogState.wrap(value))
    override val slotToElicit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slotToElicit())
      .map(value => value: String)
    override val responseCard
        : Optional[zio.aws.lexruntime.model.ResponseCard.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseCard())
        .map(value => zio.aws.lexruntime.model.ResponseCard.wrap(value))
    override val sessionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => value: String)
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexruntime.model.primitives.BotVersion(value))
    override val activeContexts
        : Optional[List[zio.aws.lexruntime.model.ActiveContext.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeContexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntime.model.ActiveContext.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PostTextResponse
  ): zio.aws.lexruntime.model.PostTextResponse.ReadOnly = new Wrapper(impl)
}
