package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lexruntime.model.primitives.{
  HttpContentType,
  Text,
  IntentName,
  ActiveContextsString,
  SensitiveString
}
import scala.jdk.CollectionConverters.*
final case class PutSessionResponse(
    contentType: Optional[HttpContentType] = Optional.Absent,
    intentName: Optional[IntentName] = Optional.Absent,
    slots: Optional[String] = Optional.Absent,
    sessionAttributes: Optional[String] = Optional.Absent,
    message: Optional[Text] = Optional.Absent,
    encodedMessage: Optional[SensitiveString] = Optional.Absent,
    messageFormat: Optional[zio.aws.lexruntime.model.MessageFormatType] =
      Optional.Absent,
    dialogState: Optional[zio.aws.lexruntime.model.DialogState] =
      Optional.Absent,
    slotToElicit: Optional[String] = Optional.Absent,
    sessionId: Optional[String] = Optional.Absent,
    activeContexts: Optional[ActiveContextsString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PutSessionResponse = {
    import PutSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PutSessionResponse
      .builder()
      .optionallyWith(
        contentType.map(value =>
          HttpContentType.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .optionallyWith(
        intentName.map(value => IntentName.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(sessionAttributes.map(value => value: java.lang.String))(
        _.sessionAttributes
      )
      .optionallyWith(
        message.map(value => Text.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        encodedMessage.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.encodedMessage)
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .optionallyWith(dialogState.map(value => value.unwrap))(_.dialogState)
      .optionallyWith(slotToElicit.map(value => value: java.lang.String))(
        _.slotToElicit
      )
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(
        activeContexts.map(value =>
          ActiveContextsString.unwrap(value): java.lang.String
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.PutSessionResponse.ReadOnly =
    zio.aws.lexruntime.model.PutSessionResponse.wrap(buildAwsValue())
}
object PutSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PutSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.PutSessionResponse =
      zio.aws.lexruntime.model.PutSessionResponse(
        contentType.map(value => value),
        intentName.map(value => value),
        slots.map(value => value),
        sessionAttributes.map(value => value),
        message.map(value => value),
        encodedMessage.map(value => value),
        messageFormat.map(value => value),
        dialogState.map(value => value),
        slotToElicit.map(value => value),
        sessionId.map(value => value),
        activeContexts.map(value => value)
      )
    def contentType: Optional[HttpContentType]
    def intentName: Optional[IntentName]
    def slots: Optional[String]
    def sessionAttributes: Optional[String]
    def message: Optional[Text]
    def encodedMessage: Optional[SensitiveString]
    def messageFormat: Optional[zio.aws.lexruntime.model.MessageFormatType]
    def dialogState: Optional[zio.aws.lexruntime.model.DialogState]
    def slotToElicit: Optional[String]
    def sessionId: Optional[String]
    def activeContexts: Optional[ActiveContextsString]
    def getContentType: ZIO[Any, AwsError, HttpContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getIntentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getSlots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slots)
    def getSessionAttributes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
    def getMessage: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("message", message)
    def getEncodedMessage: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("encodedMessage", encodedMessage)
    def getMessageFormat
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.MessageFormatType] =
      AwsError.unwrapOptionField("messageFormat", messageFormat)
    def getDialogState
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.DialogState] =
      AwsError.unwrapOptionField("dialogState", dialogState)
    def getSlotToElicit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicit)
    def getSessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getActiveContexts: ZIO[Any, AwsError, ActiveContextsString] =
      AwsError.unwrapOptionField("activeContexts", activeContexts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PutSessionResponse
  ) extends zio.aws.lexruntime.model.PutSessionResponse.ReadOnly {
    override val contentType: Optional[HttpContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.lexruntime.model.primitives.HttpContentType(value))
    override val intentName: Optional[IntentName] = zio.aws.core.internal
      .optionalFromNullable(impl.intentName())
      .map(value => zio.aws.lexruntime.model.primitives.IntentName(value))
    override val slots: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slots())
      .map(value => value: String)
    override val sessionAttributes: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionAttributes())
      .map(value => value: String)
    override val message: Optional[Text] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.lexruntime.model.primitives.Text(value))
    override val encodedMessage: Optional[SensitiveString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encodedMessage())
        .map(value =>
          zio.aws.lexruntime.model.primitives.SensitiveString(value)
        )
    override val messageFormat
        : Optional[zio.aws.lexruntime.model.MessageFormatType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageFormat())
        .map(value => zio.aws.lexruntime.model.MessageFormatType.wrap(value))
    override val dialogState: Optional[zio.aws.lexruntime.model.DialogState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dialogState())
        .map(value => zio.aws.lexruntime.model.DialogState.wrap(value))
    override val slotToElicit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slotToElicit())
      .map(value => value: String)
    override val sessionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => value: String)
    override val activeContexts: Optional[ActiveContextsString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeContexts())
        .map(value =>
          zio.aws.lexruntime.model.primitives.ActiveContextsString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PutSessionResponse
  ): zio.aws.lexruntime.model.PutSessionResponse.ReadOnly = new Wrapper(impl)
}
