package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AllocateStaticIpRequest(staticIpName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest = {
    import AllocateStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest
      .builder()
      .staticIpName(ResourceName.unwrap(staticIpName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AllocateStaticIpRequest.ReadOnly =
    zio.aws.lightsail.model.AllocateStaticIpRequest.wrap(buildAwsValue())
}
object AllocateStaticIpRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AllocateStaticIpRequest =
      zio.aws.lightsail.model.AllocateStaticIpRequest(staticIpName)
    def staticIpName: ResourceName
    def getStaticIpName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(staticIpName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest
  ) extends zio.aws.lightsail.model.AllocateStaticIpRequest.ReadOnly {
    override val staticIpName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.staticIpName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest
  ): zio.aws.lightsail.model.AllocateStaticIpRequest.ReadOnly = new Wrapper(
    impl
  )
}
