package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.TimeOfDay
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoSnapshotAddOnRequest(
    snapshotTimeOfDay: Optional[TimeOfDay] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest = {
    import AutoSnapshotAddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest
      .builder()
      .optionallyWith(
        snapshotTimeOfDay.map(value =>
          TimeOfDay.unwrap(value): java.lang.String
        )
      )(_.snapshotTimeOfDay)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly =
    zio.aws.lightsail.model.AutoSnapshotAddOnRequest.wrap(buildAwsValue())
}
object AutoSnapshotAddOnRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AutoSnapshotAddOnRequest =
      zio.aws.lightsail.model
        .AutoSnapshotAddOnRequest(snapshotTimeOfDay.map(value => value))
    def snapshotTimeOfDay: Optional[TimeOfDay]
    def getSnapshotTimeOfDay: ZIO[Any, AwsError, TimeOfDay] =
      AwsError.unwrapOptionField("snapshotTimeOfDay", snapshotTimeOfDay)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest
  ) extends zio.aws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly {
    override val snapshotTimeOfDay: Optional[TimeOfDay] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotTimeOfDay())
      .map(value => zio.aws.lightsail.model.primitives.TimeOfDay(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest
  ): zio.aws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly = new Wrapper(
    impl
  )
}
