package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{BucketName, IsoDate, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class Bucket(
    resourceType: Optional[NonEmptyString] = Optional.Absent,
    accessRules: Optional[zio.aws.lightsail.model.AccessRules] =
      Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    bundleId: Optional[NonEmptyString] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    url: Optional[NonEmptyString] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    name: Optional[BucketName] = Optional.Absent,
    supportCode: Optional[NonEmptyString] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    objectVersioning: Optional[NonEmptyString] = Optional.Absent,
    ableToUpdateBundle: Optional[Boolean] = Optional.Absent,
    readonlyAccessAccounts: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    resourcesReceivingAccess: Optional[
      Iterable[zio.aws.lightsail.model.ResourceReceivingAccess]
    ] = Optional.Absent,
    state: Optional[zio.aws.lightsail.model.BucketState] = Optional.Absent,
    accessLogConfig: Optional[zio.aws.lightsail.model.BucketAccessLogConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Bucket = {
    import Bucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Bucket
      .builder()
      .optionallyWith(
        resourceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(accessRules.map(value => value.buildAwsValue()))(
        _.accessRules
      )
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        bundleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        url.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        name.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        supportCode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.supportCode)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        objectVersioning.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.objectVersioning)
      .optionallyWith(
        ableToUpdateBundle.map(value => value: java.lang.Boolean)
      )(_.ableToUpdateBundle)
      .optionallyWith(
        readonlyAccessAccounts.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.readonlyAccessAccounts)
      .optionallyWith(
        resourcesReceivingAccess.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourcesReceivingAccess)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(accessLogConfig.map(value => value.buildAwsValue()))(
        _.accessLogConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Bucket.ReadOnly =
    zio.aws.lightsail.model.Bucket.wrap(buildAwsValue())
}
object Bucket {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Bucket] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Bucket =
      zio.aws.lightsail.model.Bucket(
        resourceType.map(value => value),
        accessRules.map(value => value.asEditable),
        arn.map(value => value),
        bundleId.map(value => value),
        createdAt.map(value => value),
        url.map(value => value),
        location.map(value => value.asEditable),
        name.map(value => value),
        supportCode.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        objectVersioning.map(value => value),
        ableToUpdateBundle.map(value => value),
        readonlyAccessAccounts.map(value => value),
        resourcesReceivingAccess.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        state.map(value => value.asEditable),
        accessLogConfig.map(value => value.asEditable)
      )
    def resourceType: Optional[NonEmptyString]
    def accessRules: Optional[zio.aws.lightsail.model.AccessRules.ReadOnly]
    def arn: Optional[NonEmptyString]
    def bundleId: Optional[NonEmptyString]
    def createdAt: Optional[IsoDate]
    def url: Optional[NonEmptyString]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def name: Optional[BucketName]
    def supportCode: Optional[NonEmptyString]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def objectVersioning: Optional[NonEmptyString]
    def ableToUpdateBundle: Optional[Boolean]
    def readonlyAccessAccounts: Optional[List[NonEmptyString]]
    def resourcesReceivingAccess: Optional[
      List[zio.aws.lightsail.model.ResourceReceivingAccess.ReadOnly]
    ]
    def state: Optional[zio.aws.lightsail.model.BucketState.ReadOnly]
    def accessLogConfig
        : Optional[zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly]
    def getResourceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getAccessRules
        : ZIO[Any, AwsError, zio.aws.lightsail.model.AccessRules.ReadOnly] =
      AwsError.unwrapOptionField("accessRules", accessRules)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("url", url)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", name)
    def getSupportCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getObjectVersioning: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("objectVersioning", objectVersioning)
    def getAbleToUpdateBundle: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ableToUpdateBundle", ableToUpdateBundle)
    def getReadonlyAccessAccounts: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "readonlyAccessAccounts",
        readonlyAccessAccounts
      )
    def getResourcesReceivingAccess: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.ResourceReceivingAccess.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourcesReceivingAccess",
      resourcesReceivingAccess
    )
    def getState
        : ZIO[Any, AwsError, zio.aws.lightsail.model.BucketState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getAccessLogConfig: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogConfig", accessLogConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Bucket
  ) extends zio.aws.lightsail.model.Bucket.ReadOnly {
    override val resourceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val accessRules
        : Optional[zio.aws.lightsail.model.AccessRules.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessRules())
        .map(value => zio.aws.lightsail.model.AccessRules.wrap(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val bundleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val url: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val name: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.BucketName(value))
    override val supportCode: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val objectVersioning: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectVersioning())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val ableToUpdateBundle: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ableToUpdateBundle())
      .map(value => value: Boolean)
    override val readonlyAccessAccounts: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readonlyAccessAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val resourcesReceivingAccess: Optional[
      List[zio.aws.lightsail.model.ResourceReceivingAccess.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourcesReceivingAccess())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.ResourceReceivingAccess.wrap(item)
        }.toList
      )
    override val state: Optional[zio.aws.lightsail.model.BucketState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.lightsail.model.BucketState.wrap(value))
    override val accessLogConfig
        : Optional[zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessLogConfig())
        .map(value => zio.aws.lightsail.model.BucketAccessLogConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Bucket
  ): zio.aws.lightsail.model.Bucket.ReadOnly = new Wrapper(impl)
}
