package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CacheBehavior(
    behavior: Optional[zio.aws.lightsail.model.BehaviorEnum] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CacheBehavior = {
    import CacheBehavior.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CacheBehavior
      .builder()
      .optionallyWith(behavior.map(value => value.unwrap))(_.behavior)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CacheBehavior.ReadOnly =
    zio.aws.lightsail.model.CacheBehavior.wrap(buildAwsValue())
}
object CacheBehavior {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CacheBehavior
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CacheBehavior =
      zio.aws.lightsail.model.CacheBehavior(behavior.map(value => value))
    def behavior: Optional[zio.aws.lightsail.model.BehaviorEnum]
    def getBehavior: ZIO[Any, AwsError, zio.aws.lightsail.model.BehaviorEnum] =
      AwsError.unwrapOptionField("behavior", behavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CacheBehavior
  ) extends zio.aws.lightsail.model.CacheBehavior.ReadOnly {
    override val behavior: Optional[zio.aws.lightsail.model.BehaviorEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.behavior())
        .map(value => zio.aws.lightsail.model.BehaviorEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CacheBehavior
  ): zio.aws.lightsail.model.CacheBehavior.ReadOnly = new Wrapper(impl)
}
