package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class CloudFormationStackRecord(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    state: Optional[zio.aws.lightsail.model.RecordState] = Optional.Absent,
    sourceInfo: Optional[
      Iterable[zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo]
    ] = Optional.Absent,
    destinationInfo: Optional[zio.aws.lightsail.model.DestinationInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecord = {
    import CloudFormationStackRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecord
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        sourceInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceInfo)
      .optionallyWith(destinationInfo.map(value => value.buildAwsValue()))(
        _.destinationInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CloudFormationStackRecord.ReadOnly =
    zio.aws.lightsail.model.CloudFormationStackRecord.wrap(buildAwsValue())
}
object CloudFormationStackRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CloudFormationStackRecord =
      zio.aws.lightsail.model.CloudFormationStackRecord(
        name.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        state.map(value => value),
        sourceInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinationInfo.map(value => value.asEditable)
      )
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def state: Optional[zio.aws.lightsail.model.RecordState]
    def sourceInfo: Optional[
      List[zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly]
    ]
    def destinationInfo
        : Optional[zio.aws.lightsail.model.DestinationInfo.ReadOnly]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getState: ZIO[Any, AwsError, zio.aws.lightsail.model.RecordState] =
      AwsError.unwrapOptionField("state", state)
    def getSourceInfo: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceInfo", sourceInfo)
    def getDestinationInfo
        : ZIO[Any, AwsError, zio.aws.lightsail.model.DestinationInfo.ReadOnly] =
      AwsError.unwrapOptionField("destinationInfo", destinationInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecord
  ) extends zio.aws.lightsail.model.CloudFormationStackRecord.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val state: Optional[zio.aws.lightsail.model.RecordState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.lightsail.model.RecordState.wrap(value))
    override val sourceInfo: Optional[
      List[zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceInfo())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.wrap(item)
        }.toList
      )
    override val destinationInfo
        : Optional[zio.aws.lightsail.model.DestinationInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationInfo())
        .map(value => zio.aws.lightsail.model.DestinationInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecord
  ): zio.aws.lightsail.model.CloudFormationStackRecord.ReadOnly = new Wrapper(
    impl
  )
}
