package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait ComparisonOperator {
  def unwrap: software.amazon.awssdk.services.lightsail.model.ComparisonOperator
}
object ComparisonOperator {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.ComparisonOperator
  ): zio.aws.lightsail.model.ComparisonOperator = value match {
    case software.amazon.awssdk.services.lightsail.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD =>
      val r = GreaterThanOrEqualToThreshold
      r
    case software.amazon.awssdk.services.lightsail.model.ComparisonOperator.GREATER_THAN_THRESHOLD =>
      val r = GreaterThanThreshold
      r
    case software.amazon.awssdk.services.lightsail.model.ComparisonOperator.LESS_THAN_THRESHOLD =>
      val r = LessThanThreshold
      r
    case software.amazon.awssdk.services.lightsail.model.ComparisonOperator.LESS_THAN_OR_EQUAL_TO_THRESHOLD =>
      val r = LessThanOrEqualToThreshold
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ComparisonOperator =
      software.amazon.awssdk.services.lightsail.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object GreaterThanOrEqualToThreshold
      extends zio.aws.lightsail.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ComparisonOperator =
      software.amazon.awssdk.services.lightsail.model.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD
  }
  case object GreaterThanThreshold
      extends zio.aws.lightsail.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ComparisonOperator =
      software.amazon.awssdk.services.lightsail.model.ComparisonOperator.GREATER_THAN_THRESHOLD
  }
  case object LessThanThreshold
      extends zio.aws.lightsail.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ComparisonOperator =
      software.amazon.awssdk.services.lightsail.model.ComparisonOperator.LESS_THAN_THRESHOLD
  }
  case object LessThanOrEqualToThreshold
      extends zio.aws.lightsail.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ComparisonOperator =
      software.amazon.awssdk.services.lightsail.model.ComparisonOperator.LESS_THAN_OR_EQUAL_TO_THRESHOLD
  }
}
