package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Container(
    image: Optional[String] = Optional.Absent,
    command: Optional[Iterable[String]] = Optional.Absent,
    environment: Optional[Map[String, String]] = Optional.Absent,
    ports: Optional[
      Map[String, zio.aws.lightsail.model.ContainerServiceProtocol]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Container = {
    import Container.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Container
      .builder()
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(
        ports.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.unwrap.toString
            })
            .asJava
        )
      )(_.portsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Container.ReadOnly =
    zio.aws.lightsail.model.Container.wrap(buildAwsValue())
}
object Container {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Container
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Container =
      zio.aws.lightsail.model.Container(
        image.map(value => value),
        command.map(value => value),
        environment.map(value => value),
        ports.map(value => value)
      )
    def image: Optional[String]
    def command: Optional[List[String]]
    def environment: Optional[Map[String, String]]
    def ports: Optional[
      Map[String, zio.aws.lightsail.model.ContainerServiceProtocol]
    ]
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getEnvironment: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("environment", environment)
    def getPorts: ZIO[Any, AwsError, Map[
      String,
      zio.aws.lightsail.model.ContainerServiceProtocol
    ]] = AwsError.unwrapOptionField("ports", ports)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Container
  ) extends zio.aws.lightsail.model.Container.ReadOnly {
    override val image: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => value: String)
    override val command: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val environment: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val ports: Optional[
      Map[String, zio.aws.lightsail.model.ContainerServiceProtocol]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ports())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.lightsail.model.ContainerServiceProtocol
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Container
  ): zio.aws.lightsail.model.Container.ReadOnly = new Wrapper(impl)
}
