package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  ContainerServiceScale,
  IsoDate,
  NonEmptyString,
  ContainerServiceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ContainerService(
    containerServiceName: Optional[ContainerServiceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    power: Optional[zio.aws.lightsail.model.ContainerServicePowerName] =
      Optional.Absent,
    powerId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.lightsail.model.ContainerServiceState] =
      Optional.Absent,
    stateDetail: Optional[zio.aws.lightsail.model.ContainerServiceStateDetail] =
      Optional.Absent,
    scale: Optional[ContainerServiceScale] = Optional.Absent,
    currentDeployment: Optional[
      zio.aws.lightsail.model.ContainerServiceDeployment
    ] = Optional.Absent,
    nextDeployment: Optional[
      zio.aws.lightsail.model.ContainerServiceDeployment
    ] = Optional.Absent,
    isDisabled: Optional[Boolean] = Optional.Absent,
    principalArn: Optional[String] = Optional.Absent,
    privateDomainName: Optional[String] = Optional.Absent,
    publicDomainNames: Optional[Map[String, Iterable[String]]] =
      Optional.Absent,
    url: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerService = {
    import ContainerService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerService
      .builder()
      .optionallyWith(
        containerServiceName.map(value =>
          ContainerServiceName.unwrap(value): java.lang.String
        )
      )(_.containerServiceName)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(power.map(value => value.unwrap))(_.power)
      .optionallyWith(powerId.map(value => value: java.lang.String))(_.powerId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateDetail.map(value => value.buildAwsValue()))(
        _.stateDetail
      )
      .optionallyWith(
        scale.map(value => ContainerServiceScale.unwrap(value): Integer)
      )(_.scale)
      .optionallyWith(currentDeployment.map(value => value.buildAwsValue()))(
        _.currentDeployment
      )
      .optionallyWith(nextDeployment.map(value => value.buildAwsValue()))(
        _.nextDeployment
      )
      .optionallyWith(isDisabled.map(value => value: java.lang.Boolean))(
        _.isDisabled
      )
      .optionallyWith(principalArn.map(value => value: java.lang.String))(
        _.principalArn
      )
      .optionallyWith(privateDomainName.map(value => value: java.lang.String))(
        _.privateDomainName
      )
      .optionallyWith(
        publicDomainNames.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.publicDomainNames)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContainerService.ReadOnly =
    zio.aws.lightsail.model.ContainerService.wrap(buildAwsValue())
}
object ContainerService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerService =
      zio.aws.lightsail.model.ContainerService(
        containerServiceName.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        power.map(value => value),
        powerId.map(value => value),
        state.map(value => value),
        stateDetail.map(value => value.asEditable),
        scale.map(value => value),
        currentDeployment.map(value => value.asEditable),
        nextDeployment.map(value => value.asEditable),
        isDisabled.map(value => value),
        principalArn.map(value => value),
        privateDomainName.map(value => value),
        publicDomainNames.map(value => value),
        url.map(value => value)
      )
    def containerServiceName: Optional[ContainerServiceName]
    def arn: Optional[NonEmptyString]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def power: Optional[zio.aws.lightsail.model.ContainerServicePowerName]
    def powerId: Optional[String]
    def state: Optional[zio.aws.lightsail.model.ContainerServiceState]
    def stateDetail
        : Optional[zio.aws.lightsail.model.ContainerServiceStateDetail.ReadOnly]
    def scale: Optional[ContainerServiceScale]
    def currentDeployment
        : Optional[zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly]
    def nextDeployment
        : Optional[zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly]
    def isDisabled: Optional[Boolean]
    def principalArn: Optional[String]
    def privateDomainName: Optional[String]
    def publicDomainNames: Optional[Map[String, List[String]]]
    def url: Optional[String]
    def getContainerServiceName: ZIO[Any, AwsError, ContainerServiceName] =
      AwsError.unwrapOptionField("containerServiceName", containerServiceName)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPower: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServicePowerName
    ] = AwsError.unwrapOptionField("power", power)
    def getPowerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("powerId", powerId)
    def getState
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ContainerServiceState] =
      AwsError.unwrapOptionField("state", state)
    def getStateDetail: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceStateDetail.ReadOnly
    ] = AwsError.unwrapOptionField("stateDetail", stateDetail)
    def getScale: ZIO[Any, AwsError, ContainerServiceScale] =
      AwsError.unwrapOptionField("scale", scale)
    def getCurrentDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("currentDeployment", currentDeployment)
    def getNextDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("nextDeployment", nextDeployment)
    def getIsDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDisabled", isDisabled)
    def getPrincipalArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalArn", principalArn)
    def getPrivateDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDomainName", privateDomainName)
    def getPublicDomainNames: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("publicDomainNames", publicDomainNames)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerService
  ) extends zio.aws.lightsail.model.ContainerService.ReadOnly {
    override val containerServiceName: Optional[ContainerServiceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerServiceName())
        .map(value =>
          zio.aws.lightsail.model.primitives.ContainerServiceName(value)
        )
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val power
        : Optional[zio.aws.lightsail.model.ContainerServicePowerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.power())
        .map(value =>
          zio.aws.lightsail.model.ContainerServicePowerName.wrap(value)
        )
    override val powerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.powerId())
      .map(value => value: String)
    override val state
        : Optional[zio.aws.lightsail.model.ContainerServiceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.lightsail.model.ContainerServiceState.wrap(value))
    override val stateDetail: Optional[
      zio.aws.lightsail.model.ContainerServiceStateDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stateDetail())
      .map(value =>
        zio.aws.lightsail.model.ContainerServiceStateDetail.wrap(value)
      )
    override val scale: Optional[ContainerServiceScale] = zio.aws.core.internal
      .optionalFromNullable(impl.scale())
      .map(value =>
        zio.aws.lightsail.model.primitives.ContainerServiceScale(value)
      )
    override val currentDeployment: Optional[
      zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.currentDeployment())
      .map(value =>
        zio.aws.lightsail.model.ContainerServiceDeployment.wrap(value)
      )
    override val nextDeployment: Optional[
      zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nextDeployment())
      .map(value =>
        zio.aws.lightsail.model.ContainerServiceDeployment.wrap(value)
      )
    override val isDisabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDisabled())
      .map(value => value: Boolean)
    override val principalArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principalArn())
      .map(value => value: String)
    override val privateDomainName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDomainName())
      .map(value => value: String)
    override val publicDomainNames: Optional[Map[String, List[String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicDomainNames())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
    override val url: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerService
  ): zio.aws.lightsail.model.ContainerService.ReadOnly = new Wrapper(impl)
}
