package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerServiceHealthCheckConfig(
    healthyThreshold: Optional[Integer] = Optional.Absent,
    unhealthyThreshold: Optional[Integer] = Optional.Absent,
    timeoutSeconds: Optional[Integer] = Optional.Absent,
    intervalSeconds: Optional[Integer] = Optional.Absent,
    path: Optional[String] = Optional.Absent,
    successCodes: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig = {
    import ContainerServiceHealthCheckConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig
      .builder()
      .optionallyWith(healthyThreshold.map(value => value: java.lang.Integer))(
        _.healthyThreshold
      )
      .optionallyWith(
        unhealthyThreshold.map(value => value: java.lang.Integer)
      )(_.unhealthyThreshold)
      .optionallyWith(timeoutSeconds.map(value => value: java.lang.Integer))(
        _.timeoutSeconds
      )
      .optionallyWith(intervalSeconds.map(value => value: java.lang.Integer))(
        _.intervalSeconds
      )
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(successCodes.map(value => value: java.lang.String))(
        _.successCodes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceHealthCheckConfig
      .wrap(buildAwsValue())
}
object ContainerServiceHealthCheckConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServiceHealthCheckConfig =
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig(
        healthyThreshold.map(value => value),
        unhealthyThreshold.map(value => value),
        timeoutSeconds.map(value => value),
        intervalSeconds.map(value => value),
        path.map(value => value),
        successCodes.map(value => value)
      )
    def healthyThreshold: Optional[Integer]
    def unhealthyThreshold: Optional[Integer]
    def timeoutSeconds: Optional[Integer]
    def intervalSeconds: Optional[Integer]
    def path: Optional[String]
    def successCodes: Optional[String]
    def getHealthyThreshold: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("healthyThreshold", healthyThreshold)
    def getUnhealthyThreshold: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("unhealthyThreshold", unhealthyThreshold)
    def getTimeoutSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
    def getIntervalSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("intervalSeconds", intervalSeconds)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getSuccessCodes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("successCodes", successCodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig
  ) extends zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly {
    override val healthyThreshold: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.healthyThreshold())
      .map(value => value: Integer)
    override val unhealthyThreshold: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.unhealthyThreshold())
      .map(value => value: Integer)
    override val timeoutSeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutSeconds())
      .map(value => value: Integer)
    override val intervalSeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.intervalSeconds())
      .map(value => value: Integer)
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
    override val successCodes: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.successCodes())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig
  ): zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly =
    new Wrapper(impl)
}
