package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.IsoDate
import scala.jdk.CollectionConverters._
final case class ContainerServiceLogEvent(
    createdAt: Optional[IsoDate] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceLogEvent = {
    import ContainerServiceLogEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceLogEvent
      .builder()
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContainerServiceLogEvent.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceLogEvent.wrap(buildAwsValue())
}
object ContainerServiceLogEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceLogEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServiceLogEvent =
      zio.aws.lightsail.model.ContainerServiceLogEvent(
        createdAt.map(value => value),
        message.map(value => value)
      )
    def createdAt: Optional[IsoDate]
    def message: Optional[String]
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceLogEvent
  ) extends zio.aws.lightsail.model.ContainerServiceLogEvent.ReadOnly {
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceLogEvent
  ): zio.aws.lightsail.model.ContainerServiceLogEvent.ReadOnly = new Wrapper(
    impl
  )
}
