package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  Integer,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDiskRequest(
    diskName: ResourceName,
    availabilityZone: NonEmptyString,
    sizeInGb: Integer,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    addOns: Optional[Iterable[zio.aws.lightsail.model.AddOnRequest]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDiskRequest = {
    import CreateDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDiskRequest
      .builder()
      .diskName(ResourceName.unwrap(diskName): java.lang.String)
      .availabilityZone(
        NonEmptyString.unwrap(availabilityZone): java.lang.String
      )
      .sizeInGb(sizeInGb: java.lang.Integer)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateDiskRequest.ReadOnly =
    zio.aws.lightsail.model.CreateDiskRequest.wrap(buildAwsValue())
}
object CreateDiskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDiskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateDiskRequest =
      zio.aws.lightsail.model.CreateDiskRequest(
        diskName,
        availabilityZone,
        sizeInGb,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addOns.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def diskName: ResourceName
    def availabilityZone: NonEmptyString
    def sizeInGb: Integer
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def addOns: Optional[List[zio.aws.lightsail.model.AddOnRequest.ReadOnly]]
    def getDiskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskName)
    def getAvailabilityZone: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(availabilityZone)
    def getSizeInGb: ZIO[Any, Nothing, Integer] = ZIO.succeed(sizeInGb)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAddOns: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.AddOnRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("addOns", addOns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskRequest
  ) extends zio.aws.lightsail.model.CreateDiskRequest.ReadOnly {
    override val diskName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.diskName())
    override val availabilityZone: NonEmptyString =
      zio.aws.lightsail.model.primitives.NonEmptyString(impl.availabilityZone())
    override val sizeInGb: Integer = impl.sizeInGb(): Integer
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val addOns
        : Optional[List[zio.aws.lightsail.model.AddOnRequest.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addOns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AddOnRequest.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskRequest
  ): zio.aws.lightsail.model.CreateDiskRequest.ReadOnly = new Wrapper(impl)
}
