package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{NonEmptyString, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateInstancesFromSnapshotRequest(
    instanceNames: Iterable[String],
    attachedDiskMapping: Optional[
      Map[ResourceName, Iterable[zio.aws.lightsail.model.DiskMap]]
    ] = Optional.Absent,
    availabilityZone: String,
    instanceSnapshotName: Optional[ResourceName] = Optional.Absent,
    bundleId: NonEmptyString,
    userData: Optional[String] = Optional.Absent,
    keyPairName: Optional[ResourceName] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    addOns: Optional[Iterable[zio.aws.lightsail.model.AddOnRequest]] =
      Optional.Absent,
    ipAddressType: Optional[zio.aws.lightsail.model.IpAddressType] =
      Optional.Absent,
    sourceInstanceName: Optional[String] = Optional.Absent,
    restoreDate: Optional[String] = Optional.Absent,
    useLatestRestorableAutoSnapshot: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest = {
    import CreateInstancesFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest
      .builder()
      .instanceNames(instanceNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        attachedDiskMapping.map(value =>
          value
            .map({ case (key, value) =>
              (ResourceName.unwrap(key): java.lang.String) -> value.map {
                item =>
                  item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.attachedDiskMapping)
      .availabilityZone(availabilityZone: java.lang.String)
      .optionallyWith(
        instanceSnapshotName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.instanceSnapshotName)
      .bundleId(NonEmptyString.unwrap(bundleId): java.lang.String)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .optionallyWith(
        keyPairName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.keyPairName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(sourceInstanceName.map(value => value: java.lang.String))(
        _.sourceInstanceName
      )
      .optionallyWith(restoreDate.map(value => value: java.lang.String))(
        _.restoreDate
      )
      .optionallyWith(
        useLatestRestorableAutoSnapshot.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableAutoSnapshot)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateInstancesFromSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.CreateInstancesFromSnapshotRequest
      .wrap(buildAwsValue())
}
object CreateInstancesFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateInstancesFromSnapshotRequest =
      zio.aws.lightsail.model.CreateInstancesFromSnapshotRequest(
        instanceNames,
        attachedDiskMapping.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        availabilityZone,
        instanceSnapshotName.map(value => value),
        bundleId,
        userData.map(value => value),
        keyPairName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addOns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipAddressType.map(value => value),
        sourceInstanceName.map(value => value),
        restoreDate.map(value => value),
        useLatestRestorableAutoSnapshot.map(value => value)
      )
    def instanceNames: List[String]
    def attachedDiskMapping: Optional[
      Map[ResourceName, List[zio.aws.lightsail.model.DiskMap.ReadOnly]]
    ]
    def availabilityZone: String
    def instanceSnapshotName: Optional[ResourceName]
    def bundleId: NonEmptyString
    def userData: Optional[String]
    def keyPairName: Optional[ResourceName]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def addOns: Optional[List[zio.aws.lightsail.model.AddOnRequest.ReadOnly]]
    def ipAddressType: Optional[zio.aws.lightsail.model.IpAddressType]
    def sourceInstanceName: Optional[String]
    def restoreDate: Optional[String]
    def useLatestRestorableAutoSnapshot: Optional[Boolean]
    def getInstanceNames: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(instanceNames)
    def getAttachedDiskMapping: ZIO[Any, AwsError, Map[ResourceName, List[
      zio.aws.lightsail.model.DiskMap.ReadOnly
    ]]] = AwsError.unwrapOptionField("attachedDiskMapping", attachedDiskMapping)
    def getAvailabilityZone: ZIO[Any, Nothing, String] =
      ZIO.succeed(availabilityZone)
    def getInstanceSnapshotName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("instanceSnapshotName", instanceSnapshotName)
    def getBundleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(bundleId)
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
    def getKeyPairName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("keyPairName", keyPairName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAddOns: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.AddOnRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("addOns", addOns)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getSourceInstanceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceInstanceName", sourceInstanceName)
    def getRestoreDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restoreDate", restoreDate)
    def getUseLatestRestorableAutoSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "useLatestRestorableAutoSnapshot",
        useLatestRestorableAutoSnapshot
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest
  ) extends zio.aws.lightsail.model.CreateInstancesFromSnapshotRequest.ReadOnly {
    override val instanceNames: List[String] = impl
      .instanceNames()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val attachedDiskMapping: Optional[
      Map[ResourceName, List[zio.aws.lightsail.model.DiskMap.ReadOnly]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachedDiskMapping())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lightsail.model.primitives
              .ResourceName(key) -> value.asScala.map { item =>
              zio.aws.lightsail.model.DiskMap.wrap(item)
            }.toList
          })
          .toMap
      )
    override val availabilityZone: String = impl.availabilityZone(): String
    override val instanceSnapshotName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceSnapshotName())
        .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val bundleId: NonEmptyString =
      zio.aws.lightsail.model.primitives.NonEmptyString(impl.bundleId())
    override val userData: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userData())
      .map(value => value: String)
    override val keyPairName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPairName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val addOns
        : Optional[List[zio.aws.lightsail.model.AddOnRequest.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addOns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AddOnRequest.wrap(item)
          }.toList
        )
    override val ipAddressType
        : Optional[zio.aws.lightsail.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.lightsail.model.IpAddressType.wrap(value))
    override val sourceInstanceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceInstanceName())
      .map(value => value: String)
    override val restoreDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreDate())
      .map(value => value: String)
    override val useLatestRestorableAutoSnapshot: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useLatestRestorableAutoSnapshot())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest
  ): zio.aws.lightsail.model.CreateInstancesFromSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
