package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Base64
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKeyPairResponse(
    keyPair: Optional[zio.aws.lightsail.model.KeyPair] = Optional.Absent,
    publicKeyBase64: Optional[Base64] = Optional.Absent,
    privateKeyBase64: Optional[Base64] = Optional.Absent,
    operation: Optional[zio.aws.lightsail.model.Operation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse = {
    import CreateKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse
      .builder()
      .optionallyWith(keyPair.map(value => value.buildAwsValue()))(_.keyPair)
      .optionallyWith(
        publicKeyBase64.map(value => Base64.unwrap(value): java.lang.String)
      )(_.publicKeyBase64)
      .optionallyWith(
        privateKeyBase64.map(value => Base64.unwrap(value): java.lang.String)
      )(_.privateKeyBase64)
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateKeyPairResponse.ReadOnly =
    zio.aws.lightsail.model.CreateKeyPairResponse.wrap(buildAwsValue())
}
object CreateKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateKeyPairResponse =
      zio.aws.lightsail.model.CreateKeyPairResponse(
        keyPair.map(value => value.asEditable),
        publicKeyBase64.map(value => value),
        privateKeyBase64.map(value => value),
        operation.map(value => value.asEditable)
      )
    def keyPair: Optional[zio.aws.lightsail.model.KeyPair.ReadOnly]
    def publicKeyBase64: Optional[Base64]
    def privateKeyBase64: Optional[Base64]
    def operation: Optional[zio.aws.lightsail.model.Operation.ReadOnly]
    def getKeyPair
        : ZIO[Any, AwsError, zio.aws.lightsail.model.KeyPair.ReadOnly] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getPublicKeyBase64: ZIO[Any, AwsError, Base64] =
      AwsError.unwrapOptionField("publicKeyBase64", publicKeyBase64)
    def getPrivateKeyBase64: ZIO[Any, AwsError, Base64] =
      AwsError.unwrapOptionField("privateKeyBase64", privateKeyBase64)
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse
  ) extends zio.aws.lightsail.model.CreateKeyPairResponse.ReadOnly {
    override val keyPair: Optional[zio.aws.lightsail.model.KeyPair.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPair())
        .map(value => zio.aws.lightsail.model.KeyPair.wrap(value))
    override val publicKeyBase64: Optional[Base64] = zio.aws.core.internal
      .optionalFromNullable(impl.publicKeyBase64())
      .map(value => zio.aws.lightsail.model.primitives.Base64(value))
    override val privateKeyBase64: Optional[Base64] = zio.aws.core.internal
      .optionalFromNullable(impl.privateKeyBase64())
      .map(value => zio.aws.lightsail.model.primitives.Base64(value))
    override val operation
        : Optional[zio.aws.lightsail.model.Operation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse
  ): zio.aws.lightsail.model.CreateKeyPairResponse.ReadOnly = new Wrapper(impl)
}
