package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{IsoDate, ResourceName}
import scala.jdk.CollectionConverters._
final case class CreateRelationalDatabaseFromSnapshotRequest(
    relationalDatabaseName: ResourceName,
    availabilityZone: Optional[String] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    relationalDatabaseSnapshotName: Optional[ResourceName] = Optional.Absent,
    relationalDatabaseBundleId: Optional[String] = Optional.Absent,
    sourceRelationalDatabaseName: Optional[ResourceName] = Optional.Absent,
    restoreTime: Optional[IsoDate] = Optional.Absent,
    useLatestRestorableTime: Optional[Boolean] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest = {
    import CreateRelationalDatabaseFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        relationalDatabaseSnapshotName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.relationalDatabaseSnapshotName)
      .optionallyWith(
        relationalDatabaseBundleId.map(value => value: java.lang.String)
      )(_.relationalDatabaseBundleId)
      .optionallyWith(
        sourceRelationalDatabaseName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.sourceRelationalDatabaseName)
      .optionallyWith(restoreTime.map(value => IsoDate.unwrap(value): Instant))(
        _.restoreTime
      )
      .optionallyWith(
        useLatestRestorableTime.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest
      .wrap(buildAwsValue())
}
object CreateRelationalDatabaseFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest =
      zio.aws.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest(
        relationalDatabaseName,
        availabilityZone.map(value => value),
        publiclyAccessible.map(value => value),
        relationalDatabaseSnapshotName.map(value => value),
        relationalDatabaseBundleId.map(value => value),
        sourceRelationalDatabaseName.map(value => value),
        restoreTime.map(value => value),
        useLatestRestorableTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def relationalDatabaseName: ResourceName
    def availabilityZone: Optional[String]
    def publiclyAccessible: Optional[Boolean]
    def relationalDatabaseSnapshotName: Optional[ResourceName]
    def relationalDatabaseBundleId: Optional[String]
    def sourceRelationalDatabaseName: Optional[ResourceName]
    def restoreTime: Optional[IsoDate]
    def useLatestRestorableTime: Optional[Boolean]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getRelationalDatabaseSnapshotName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField(
        "relationalDatabaseSnapshotName",
        relationalDatabaseSnapshotName
      )
    def getRelationalDatabaseBundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "relationalDatabaseBundleId",
        relationalDatabaseBundleId
      )
    def getSourceRelationalDatabaseName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField(
        "sourceRelationalDatabaseName",
        sourceRelationalDatabaseName
      )
    def getRestoreTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("restoreTime", restoreTime)
    def getUseLatestRestorableTime: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("useLatestRestorableTime", useLatestRestorableTime)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest
  ) extends zio.aws.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val relationalDatabaseSnapshotName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationalDatabaseSnapshotName())
        .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val relationalDatabaseBundleId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationalDatabaseBundleId())
        .map(value => value: String)
    override val sourceRelationalDatabaseName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceRelationalDatabaseName())
        .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val restoreTime: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreTime())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val useLatestRestorableTime: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useLatestRestorableTime())
        .map(value => value: Boolean)
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest
  ): zio.aws.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
