package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{AutoSnapshotDate, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAutoSnapshotRequest(
    resourceName: ResourceName,
    date: AutoSnapshotDate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest = {
    import DeleteAutoSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest
      .builder()
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .date(AutoSnapshotDate.unwrap(date): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteAutoSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteAutoSnapshotRequest.wrap(buildAwsValue())
}
object DeleteAutoSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteAutoSnapshotRequest =
      zio.aws.lightsail.model.DeleteAutoSnapshotRequest(resourceName, date)
    def resourceName: ResourceName
    def date: AutoSnapshotDate
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
    def getDate: ZIO[Any, Nothing, AutoSnapshotDate] = ZIO.succeed(date)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest
  ) extends zio.aws.lightsail.model.DeleteAutoSnapshotRequest.ReadOnly {
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
    override val date: AutoSnapshotDate =
      zio.aws.lightsail.model.primitives.AutoSnapshotDate(impl.date())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest
  ): zio.aws.lightsail.model.DeleteAutoSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
