package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteInstanceRequest(
    instanceName: ResourceName,
    forceDeleteAddOns: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest = {
    import DeleteInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest
      .builder()
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .optionallyWith(forceDeleteAddOns.map(value => value: java.lang.Boolean))(
        _.forceDeleteAddOns
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteInstanceRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteInstanceRequest.wrap(buildAwsValue())
}
object DeleteInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteInstanceRequest =
      zio.aws.lightsail.model.DeleteInstanceRequest(
        instanceName,
        forceDeleteAddOns.map(value => value)
      )
    def instanceName: ResourceName
    def forceDeleteAddOns: Optional[Boolean]
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
    def getForceDeleteAddOns: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDeleteAddOns", forceDeleteAddOns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest
  ) extends zio.aws.lightsail.model.DeleteInstanceRequest.ReadOnly {
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
    override val forceDeleteAddOns: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceDeleteAddOns())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest
  ): zio.aws.lightsail.model.DeleteInstanceRequest.ReadOnly = new Wrapper(impl)
}
