package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteLoadBalancerRequest(loadBalancerName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest = {
    import DeleteLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest
      .builder()
      .loadBalancerName(ResourceName.unwrap(loadBalancerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteLoadBalancerRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteLoadBalancerRequest.wrap(buildAwsValue())
}
object DeleteLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteLoadBalancerRequest =
      zio.aws.lightsail.model.DeleteLoadBalancerRequest(loadBalancerName)
    def loadBalancerName: ResourceName
    def getLoadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest
  ) extends zio.aws.lightsail.model.DeleteLoadBalancerRequest.ReadOnly {
    override val loadBalancerName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.loadBalancerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest
  ): zio.aws.lightsail.model.DeleteLoadBalancerRequest.ReadOnly = new Wrapper(
    impl
  )
}
