package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableAddOnRequest(
    resourceName: ResourceName,
    addOnRequest: zio.aws.lightsail.model.AddOnRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest = {
    import EnableAddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest
      .builder()
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .addOnRequest(addOnRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.EnableAddOnRequest.ReadOnly =
    zio.aws.lightsail.model.EnableAddOnRequest.wrap(buildAwsValue())
}
object EnableAddOnRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.EnableAddOnRequest =
      zio.aws.lightsail.model
        .EnableAddOnRequest(resourceName, addOnRequest.asEditable)
    def resourceName: ResourceName
    def addOnRequest: zio.aws.lightsail.model.AddOnRequest.ReadOnly
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
    def getAddOnRequest
        : ZIO[Any, Nothing, zio.aws.lightsail.model.AddOnRequest.ReadOnly] =
      ZIO.succeed(addOnRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest
  ) extends zio.aws.lightsail.model.EnableAddOnRequest.ReadOnly {
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
    override val addOnRequest: zio.aws.lightsail.model.AddOnRequest.ReadOnly =
      zio.aws.lightsail.model.AddOnRequest.wrap(impl.addOnRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest
  ): zio.aws.lightsail.model.EnableAddOnRequest.ReadOnly = new Wrapper(impl)
}
