package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{NonEmptyString, IsoDate}
import scala.jdk.CollectionConverters._
final case class ExportSnapshotRecordSourceInfo(
    resourceType: Optional[
      zio.aws.lightsail.model.ExportSnapshotRecordSourceType
    ] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    fromResourceName: Optional[NonEmptyString] = Optional.Absent,
    fromResourceArn: Optional[NonEmptyString] = Optional.Absent,
    instanceSnapshotInfo: Optional[
      zio.aws.lightsail.model.InstanceSnapshotInfo
    ] = Optional.Absent,
    diskSnapshotInfo: Optional[zio.aws.lightsail.model.DiskSnapshotInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo = {
    import ExportSnapshotRecordSourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        fromResourceName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fromResourceName)
      .optionallyWith(
        fromResourceArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fromResourceArn)
      .optionallyWith(instanceSnapshotInfo.map(value => value.buildAwsValue()))(
        _.instanceSnapshotInfo
      )
      .optionallyWith(diskSnapshotInfo.map(value => value.buildAwsValue()))(
        _.diskSnapshotInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.ExportSnapshotRecordSourceInfo.ReadOnly =
    zio.aws.lightsail.model.ExportSnapshotRecordSourceInfo.wrap(buildAwsValue())
}
object ExportSnapshotRecordSourceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ExportSnapshotRecordSourceInfo =
      zio.aws.lightsail.model.ExportSnapshotRecordSourceInfo(
        resourceType.map(value => value),
        createdAt.map(value => value),
        name.map(value => value),
        arn.map(value => value),
        fromResourceName.map(value => value),
        fromResourceArn.map(value => value),
        instanceSnapshotInfo.map(value => value.asEditable),
        diskSnapshotInfo.map(value => value.asEditable)
      )
    def resourceType
        : Optional[zio.aws.lightsail.model.ExportSnapshotRecordSourceType]
    def createdAt: Optional[IsoDate]
    def name: Optional[NonEmptyString]
    def arn: Optional[NonEmptyString]
    def fromResourceName: Optional[NonEmptyString]
    def fromResourceArn: Optional[NonEmptyString]
    def instanceSnapshotInfo
        : Optional[zio.aws.lightsail.model.InstanceSnapshotInfo.ReadOnly]
    def diskSnapshotInfo
        : Optional[zio.aws.lightsail.model.DiskSnapshotInfo.ReadOnly]
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ExportSnapshotRecordSourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getFromResourceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromResourceName", fromResourceName)
    def getFromResourceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromResourceArn", fromResourceArn)
    def getInstanceSnapshotInfo: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.InstanceSnapshotInfo.ReadOnly
    ] = AwsError.unwrapOptionField("instanceSnapshotInfo", instanceSnapshotInfo)
    def getDiskSnapshotInfo: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.DiskSnapshotInfo.ReadOnly
    ] = AwsError.unwrapOptionField("diskSnapshotInfo", diskSnapshotInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo
  ) extends zio.aws.lightsail.model.ExportSnapshotRecordSourceInfo.ReadOnly {
    override val resourceType
        : Optional[zio.aws.lightsail.model.ExportSnapshotRecordSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.lightsail.model.ExportSnapshotRecordSourceType.wrap(value)
        )
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val fromResourceName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromResourceName())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val fromResourceArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromResourceArn())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val instanceSnapshotInfo
        : Optional[zio.aws.lightsail.model.InstanceSnapshotInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceSnapshotInfo())
        .map(value => zio.aws.lightsail.model.InstanceSnapshotInfo.wrap(value))
    override val diskSnapshotInfo
        : Optional[zio.aws.lightsail.model.DiskSnapshotInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskSnapshotInfo())
        .map(value => zio.aws.lightsail.model.DiskSnapshotInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo
  ): zio.aws.lightsail.model.ExportSnapshotRecordSourceInfo.ReadOnly =
    new Wrapper(impl)
}
