package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAutoSnapshotsResponse(
    resourceName: Optional[ResourceName] = Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    autoSnapshots: Optional[
      Iterable[zio.aws.lightsail.model.AutoSnapshotDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse = {
    import GetAutoSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse
      .builder()
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        autoSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoSnapshots)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly =
    zio.aws.lightsail.model.GetAutoSnapshotsResponse.wrap(buildAwsValue())
}
object GetAutoSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetAutoSnapshotsResponse =
      zio.aws.lightsail.model.GetAutoSnapshotsResponse(
        resourceName.map(value => value),
        resourceType.map(value => value),
        autoSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceName: Optional[ResourceName]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def autoSnapshots
        : Optional[List[zio.aws.lightsail.model.AutoSnapshotDetails.ReadOnly]]
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getAutoSnapshots: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.AutoSnapshotDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("autoSnapshots", autoSnapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse
  ) extends zio.aws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly {
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val autoSnapshots
        : Optional[List[zio.aws.lightsail.model.AutoSnapshotDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoSnapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AutoSnapshotDetails.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse
  ): zio.aws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly = new Wrapper(
    impl
  )
}
