package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBucketsResponse(
    buckets: Optional[Iterable[zio.aws.lightsail.model.Bucket]] =
      Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent,
    accountLevelBpaSync: Optional[zio.aws.lightsail.model.AccountLevelBpaSync] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketsResponse = {
    import GetBucketsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketsResponse
      .builder()
      .optionallyWith(
        buckets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buckets)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .optionallyWith(accountLevelBpaSync.map(value => value.buildAwsValue()))(
        _.accountLevelBpaSync
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBucketsResponse.ReadOnly =
    zio.aws.lightsail.model.GetBucketsResponse.wrap(buildAwsValue())
}
object GetBucketsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBucketsResponse =
      zio.aws.lightsail.model.GetBucketsResponse(
        buckets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value),
        accountLevelBpaSync.map(value => value.asEditable)
      )
    def buckets: Optional[List[zio.aws.lightsail.model.Bucket.ReadOnly]]
    def nextPageToken: Optional[String]
    def accountLevelBpaSync
        : Optional[zio.aws.lightsail.model.AccountLevelBpaSync.ReadOnly]
    def getBuckets
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Bucket.ReadOnly]] =
      AwsError.unwrapOptionField("buckets", buckets)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
    def getAccountLevelBpaSync: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.AccountLevelBpaSync.ReadOnly
    ] = AwsError.unwrapOptionField("accountLevelBpaSync", accountLevelBpaSync)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketsResponse
  ) extends zio.aws.lightsail.model.GetBucketsResponse.ReadOnly {
    override val buckets
        : Optional[List[zio.aws.lightsail.model.Bucket.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buckets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Bucket.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
    override val accountLevelBpaSync
        : Optional[zio.aws.lightsail.model.AccountLevelBpaSync.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountLevelBpaSync())
        .map(value => zio.aws.lightsail.model.AccountLevelBpaSync.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketsResponse
  ): zio.aws.lightsail.model.GetBucketsResponse.ReadOnly = new Wrapper(impl)
}
