package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBundlesResponse(
    bundles: Optional[Iterable[zio.aws.lightsail.model.Bundle]] =
      Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBundlesResponse = {
    import GetBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBundlesResponse
      .builder()
      .optionallyWith(
        bundles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bundles)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBundlesResponse.ReadOnly =
    zio.aws.lightsail.model.GetBundlesResponse.wrap(buildAwsValue())
}
object GetBundlesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBundlesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBundlesResponse =
      zio.aws.lightsail.model.GetBundlesResponse(
        bundles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def bundles: Optional[List[zio.aws.lightsail.model.Bundle.ReadOnly]]
    def nextPageToken: Optional[String]
    def getBundles
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Bundle.ReadOnly]] =
      AwsError.unwrapOptionField("bundles", bundles)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBundlesResponse
  ) extends zio.aws.lightsail.model.GetBundlesResponse.ReadOnly {
    override val bundles
        : Optional[List[zio.aws.lightsail.model.Bundle.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bundles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Bundle.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBundlesResponse
  ): zio.aws.lightsail.model.GetBundlesResponse.ReadOnly = new Wrapper(impl)
}
