package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCloudFormationStackRecordsResponse(
    cloudFormationStackRecords: Optional[
      Iterable[zio.aws.lightsail.model.CloudFormationStackRecord]
    ] = Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse = {
    import GetCloudFormationStackRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse
      .builder()
      .optionallyWith(
        cloudFormationStackRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudFormationStackRecords)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly =
    zio.aws.lightsail.model.GetCloudFormationStackRecordsResponse
      .wrap(buildAwsValue())
}
object GetCloudFormationStackRecordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetCloudFormationStackRecordsResponse =
      zio.aws.lightsail.model.GetCloudFormationStackRecordsResponse(
        cloudFormationStackRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def cloudFormationStackRecords: Optional[
      List[zio.aws.lightsail.model.CloudFormationStackRecord.ReadOnly]
    ]
    def nextPageToken: Optional[String]
    def getCloudFormationStackRecords: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.CloudFormationStackRecord.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudFormationStackRecords",
      cloudFormationStackRecords
    )
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse
  ) extends zio.aws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly {
    override val cloudFormationStackRecords: Optional[
      List[zio.aws.lightsail.model.CloudFormationStackRecord.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudFormationStackRecords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.CloudFormationStackRecord.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse
  ): zio.aws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly =
    new Wrapper(impl)
}
