package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContainerLogResponse(
    logEvents: Optional[
      Iterable[zio.aws.lightsail.model.ContainerServiceLogEvent]
    ] = Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse = {
    import GetContainerLogResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse
      .builder()
      .optionallyWith(
        logEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logEvents)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetContainerLogResponse.ReadOnly =
    zio.aws.lightsail.model.GetContainerLogResponse.wrap(buildAwsValue())
}
object GetContainerLogResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetContainerLogResponse =
      zio.aws.lightsail.model.GetContainerLogResponse(
        logEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def logEvents: Optional[
      List[zio.aws.lightsail.model.ContainerServiceLogEvent.ReadOnly]
    ]
    def nextPageToken: Optional[String]
    def getLogEvents: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.ContainerServiceLogEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("logEvents", logEvents)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse
  ) extends zio.aws.lightsail.model.GetContainerLogResponse.ReadOnly {
    override val logEvents: Optional[
      List[zio.aws.lightsail.model.ContainerServiceLogEvent.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.ContainerServiceLogEvent.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse
  ): zio.aws.lightsail.model.GetContainerLogResponse.ReadOnly = new Wrapper(
    impl
  )
}
