package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContainerServicePowersResponse(
    powers: Optional[Iterable[zio.aws.lightsail.model.ContainerServicePower]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse = {
    import GetContainerServicePowersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse
      .builder()
      .optionallyWith(
        powers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.powers)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetContainerServicePowersResponse.ReadOnly =
    zio.aws.lightsail.model.GetContainerServicePowersResponse
      .wrap(buildAwsValue())
}
object GetContainerServicePowersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetContainerServicePowersResponse =
      zio.aws.lightsail.model.GetContainerServicePowersResponse(
        powers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def powers
        : Optional[List[zio.aws.lightsail.model.ContainerServicePower.ReadOnly]]
    def getPowers: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.ContainerServicePower.ReadOnly
    ]] = AwsError.unwrapOptionField("powers", powers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse
  ) extends zio.aws.lightsail.model.GetContainerServicePowersResponse.ReadOnly {
    override val powers: Optional[
      List[zio.aws.lightsail.model.ContainerServicePower.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.powers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.ContainerServicePower.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse
  ): zio.aws.lightsail.model.GetContainerServicePowersResponse.ReadOnly =
    new Wrapper(impl)
}
