package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDiskSnapshotsResponse(
    diskSnapshots: Optional[Iterable[zio.aws.lightsail.model.DiskSnapshot]] =
      Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse = {
    import GetDiskSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse
      .builder()
      .optionallyWith(
        diskSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.diskSnapshots)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly =
    zio.aws.lightsail.model.GetDiskSnapshotsResponse.wrap(buildAwsValue())
}
object GetDiskSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDiskSnapshotsResponse =
      zio.aws.lightsail.model.GetDiskSnapshotsResponse(
        diskSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def diskSnapshots
        : Optional[List[zio.aws.lightsail.model.DiskSnapshot.ReadOnly]]
    def nextPageToken: Optional[String]
    def getDiskSnapshots: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.DiskSnapshot.ReadOnly
    ]] = AwsError.unwrapOptionField("diskSnapshots", diskSnapshots)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse
  ) extends zio.aws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly {
    override val diskSnapshots
        : Optional[List[zio.aws.lightsail.model.DiskSnapshot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskSnapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.DiskSnapshot.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse
  ): zio.aws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly = new Wrapper(
    impl
  )
}
