package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetInstanceSnapshotRequest(
    instanceSnapshotName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest = {
    import GetInstanceSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest
      .builder()
      .instanceSnapshotName(
        ResourceName.unwrap(instanceSnapshotName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetInstanceSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.GetInstanceSnapshotRequest.wrap(buildAwsValue())
}
object GetInstanceSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstanceSnapshotRequest =
      zio.aws.lightsail.model.GetInstanceSnapshotRequest(instanceSnapshotName)
    def instanceSnapshotName: ResourceName
    def getInstanceSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceSnapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest
  ) extends zio.aws.lightsail.model.GetInstanceSnapshotRequest.ReadOnly {
    override val instanceSnapshotName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.instanceSnapshotName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest
  ): zio.aws.lightsail.model.GetInstanceSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
