package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInstanceStateResponse(
    state: Optional[zio.aws.lightsail.model.InstanceState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse = {
    import GetInstanceStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse
      .builder()
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetInstanceStateResponse.ReadOnly =
    zio.aws.lightsail.model.GetInstanceStateResponse.wrap(buildAwsValue())
}
object GetInstanceStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstanceStateResponse =
      zio.aws.lightsail.model
        .GetInstanceStateResponse(state.map(value => value.asEditable))
    def state: Optional[zio.aws.lightsail.model.InstanceState.ReadOnly]
    def getState
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstanceState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse
  ) extends zio.aws.lightsail.model.GetInstanceStateResponse.ReadOnly {
    override val state
        : Optional[zio.aws.lightsail.model.InstanceState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.lightsail.model.InstanceState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse
  ): zio.aws.lightsail.model.GetInstanceStateResponse.ReadOnly = new Wrapper(
    impl
  )
}
