package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInstancesResponse(
    instances: Optional[Iterable[zio.aws.lightsail.model.Instance]] =
      Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstancesResponse = {
    import GetInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstancesResponse
      .builder()
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetInstancesResponse.ReadOnly =
    zio.aws.lightsail.model.GetInstancesResponse.wrap(buildAwsValue())
}
object GetInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstancesResponse =
      zio.aws.lightsail.model.GetInstancesResponse(
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def instances: Optional[List[zio.aws.lightsail.model.Instance.ReadOnly]]
    def nextPageToken: Optional[String]
    def getInstances
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Instance.ReadOnly]] =
      AwsError.unwrapOptionField("instances", instances)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancesResponse
  ) extends zio.aws.lightsail.model.GetInstancesResponse.ReadOnly {
    override val instances
        : Optional[List[zio.aws.lightsail.model.Instance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Instance.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancesResponse
  ): zio.aws.lightsail.model.GetInstancesResponse.ReadOnly = new Wrapper(impl)
}
