package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseBlueprintsRequest(
    pageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest = {
    import GetRelationalDatabaseBlueprintsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsRequest.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseBlueprintsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsRequest =
      zio.aws.lightsail.model
        .GetRelationalDatabaseBlueprintsRequest(pageToken.map(value => value))
    def pageToken: Optional[String]
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsRequest.ReadOnly {
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest
  ): zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsRequest.ReadOnly =
    new Wrapper(impl)
}
